<?php
defined('_JEXEC') or die('Restricted access');

class pm_sttpaykeeper extends PaymentRoot{

    private $fiscal_cart = array(); //fz54 cart
    private $order_total = 0; //order total sum
    private $shipping_price = 0; //shipping price
    private $use_taxes = false;
    private $use_delivery = false;
    private $delivery_index = -1;
    private $single_item_index = -1;
    private $more_then_one_item_index = -1;
    private $order_params = NULL;
    private $discounts = array();

	function showPaymentForm($params, $pmconfigs){
		include(dirname(__FILE__)."/paymentform.php");
	}

	function showAdminFormParams($params){
		$array_params = array('user_id', 'form_url', 'secret', 'transaction_end_status', 'transaction_pending_status', 'transaction_failed_status', 'server');
		foreach ($array_params as $key){
			if (!isset($params[$key])) $params[$key] = '';
		} 
		$orders = JModelLegacy::getInstance('orders', 'JshoppingModel'); //admin model
		JSFactory::loadExtAdminLanguageFile('sttpaykeeper');
		include(dirname(__FILE__)."/adminparamsform.php");
	}

	function checkTransaction($params, $order, $act){
		$paykeeper_data = JRequest::get('post');
		if (!array_key_exists ('orderid', $paykeeper_data) || !isset($paykeeper_data['orderid'])) {
			return array(0,'error orderid');
		} 
		$order_id 	= $paykeeper_data['orderid'];
		$sum = $paykeeper_data['sum'];
		$notify_signature = $paykeeper_data['key'];

		$totalInPaymentCurrency = round($order->order_total/$order->currency_exchange,2);
		
		if ($sum != $totalInPaymentCurrency) {
			return array(0,'error sum. Order ID '.$order->order_id. ' error: '.$sum. ' <> '.$totalInPaymentCurrency);
		}
		$secret_key = $params['secret'];
		$concat = $paykeeper_data['id'].sprintf("%.2lf", $sum).$paykeeper_data['clientid'].$order_id.$secret_key;
		$sig = md5($concat);
		if (strcmp( $sig, $notify_signature) == 0 ) {
			$hash = md5($paykeeper_data['id'].$secret_key);
			echo 'OK '.$hash;
			return array(1, $order_id);
		} else {
			return array(0,'error signature. Order ID '.$order->order_id. ' $sig='.$sig. ' $notify_signature='.$notify_signature);
		}
	}
	
	function nofityFinish($pmconfigs, $order, $rescode)
	{
		return $this->notifyFinish($pmconfigs, $order, $rescode);
	}
	function notifyFinish($pmconfigs, $order, $rescode)
	{
		if($rescode==1) {
			jexit();
		}
		return;
	}

	function showEndForm($params, $order){
		
        //set order parameters
        $this->setOrderParams($order->order_total/$order->currency_exchange, //sum
                              $order->f_name
                              . " " .
                              $order->l_name, //clientid
                              $order->order_id, //orderid
                              $order->email, //client_email
                              $order->phone, //client_phone
                              "", //service_name
                              $params["form_url"], //payment form url
                              $params["secret"] //secret key
        );

        //GENERATE FZ54 CART
        $cart_check_sum = 0;

        foreach ($order->getAllItems() as $cart_item) {
            $taxes = array("tax" => "none", "tax_sum" => 0);
            $name = $cart_item->product_name;
            $qty = floatval($cart_item->product_quantity);
            $price = floatval($cart_item->product_item_price);
            if ($price <= 0)
                continue;
            $sum = $price*$qty;
            $cart_check_sum += $price*$qty;

            $tax_rate = (int) $cart_item->product_tax; //tax_rate >= 0
            $taxes = $this->setTaxes($tax_rate);
            $this->updateFiscalCart($this->getPaymentFormType(),
                                    $name, $price, $qty, $sum, $taxes["tax"]);
        }

        //add shipping parameters to cart
        $shipping_tax_rate = 0;
        $shipping_taxes = array("tax" => "none", "tax_sum" => 0);

        $this->setShippingPrice(floatval($order->order_shipping));
        $shipping_name = $order->getShippingName();
        //check if delivery already in cart
        $this->checkDeliveryIncluded($this->getShippingPrice(), $shipping_name);
        if (!$this->checkDeliveryIncluded($this->getShippingPrice(), $shipping_name)
            && $this->getShippingPrice() > 0) {
            $shipping_tax_rate = (int) $order->shipping_tax;
            $shipping_taxes = $this->setTaxes($shipping_tax_rate);
            $this->setUseDelivery(); //for precision correct check
            $this->updateFiscalCart($this->getPaymentFormType(),
                                    $shipping_name,
                                    $this->getShippingPrice(), 1, 
                                    $this->getShippingPrice(), 
                                    $shipping_taxes["tax"]);
            $this->delivery_index = count($this->getFiscalCart())-1;
        }

        //set discounts
        $this->setDiscounts(((float) $order->order_discount > 0));

        //handle possible precision problem
        $this->correctPrecision();

        $fiscal_cart_encoded = json_encode($this->getFiscalCart());

        //generate payment form
        $form = "";
        if ($this->getPaymentFormType() == "create") { //create form
            $to_hash = number_format($this->getOrderTotal(), 2, ".", "") .
                       $this->getOrderParams("clientid")     .
                       $this->getOrderParams("orderid")      .
                       $this->getOrderParams("service_name") .
                       $this->getOrderParams("client_email") .
                       $this->getOrderParams("client_phone") .
                       $this->getOrderParams("secret_key");
            $sign = hash ('sha256' , $to_hash);
            $form = '
                <h3>Сейчас Вы будете перенаправлены на страницу банка.</h3> 
                <form name="payment" id="pay_form" action="'.$this->getOrderParams("form_url").'" accept-charset="utf-8" method="post">
                <input type="hidden" name="sum" value = "'.$this->getOrderTotal().'"/>
                <input type="hidden" name="orderid" value = "'.$this->getOrderParams("orderid").'"/>
                <input type="hidden" name="clientid" value = "'.$this->getOrderParams("clientid").'"/>
                <input type="hidden" name="client_email" value = "'.$this->getOrderParams("client_email").'"/>
                <input type="hidden" name="client_phone" value = "'.$this->getOrderParams("client_phone").'"/>
                <input type="hidden" name="service_name" value = "'.$this->getOrderParams("service_name").'"/>
                <input type="hidden" name="cart" value = \''.htmlentities($fiscal_cart_encoded,ENT_QUOTES).'\' />
                <input type="hidden" name="sign" value = "'.$sign.'"/>
                <input type="submit" class="btn btn-default" value="Оплатить"/>
                </form>
                <script type="text/javascript">
                window.onload=function(){
                    setTimeout(fSubmit, 2000);
                }
                function fSubmit() {
                    document.forms["pay_form"].submit();
                }
                </script>';
        }
        else { //order form
            $payment_parameters = array(
                "clientid"=>$this->getOrderParams("clientid"), 
                "orderid"=>$this->getOrderParams('orderid'), 
                "sum"=>$this->getOrderTotal(), 
                "phone"=>$this->getOrderParams("phone"), 
                "client_email"=>$this->getOrderParams("client_email"), 
                "cart"=>$fiscal_cart_encoded);
            $query = http_build_query($payment_parameters);
            $query_options = array("http"=>array(
                "method"=>"POST",
                "header"=>"Content-type: application/x-www-form-urlencoded",
                "content"=>$query
                ));
            $context = stream_context_create($query_options);

            $err_num = $err_text = NULL;
            if( function_exists( "curl_init" )) { //using curl
                $CR = curl_init();
                curl_setopt($CR, CURLOPT_URL, $this->getOrderParams("form_url"));
                curl_setopt($CR, CURLOPT_POST, 1);
                curl_setopt($CR, CURLOPT_FAILONERROR, true); 
                curl_setopt($CR, CURLOPT_POSTFIELDS, $query);
                curl_setopt($CR, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($CR, CURLOPT_SSL_VERIFYPEER, 0);
                $result = curl_exec( $CR );
                $error = curl_error( $CR );
                if( !empty( $error )) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR:".$error."</span>";
                    return false;
                }
                else {
                    $form = $result;
                }
                curl_close($CR);
            }
            else { //using file_get_contents
                if (!ini_get('allow_url_fopen')) {
                    $form_html = "<br/><span class=message>"."INTERNAL ERROR: Option allow_url_fopen is not set in php.ini"."</span>";
                }
                else {
                    $form = file_get_contents($server, false, $context);
                }
            }
        }
        if ($form  == "") {
            $form = '<h3>Произошла ошибка при инциализации платежа</h3><p>$err_num: '.htmlspecialchars($err_text).'</p>';
        }

        echo $form;
	}
	
	function getUrlParams($pmconfigs){
		$params = array(); 
		$params['order_id'] = JRequest::getInt("orderid");
		$params['hash'] = "";
		$params['checkHash'] = 0;
		$params['checkReturnParams'] = 0;        
		return $params;
	}
	
    private function setOrderParams($order_total = 0, $clientid="", $orderid="", $client_email="", 
                                    $client_phone="", $service_name="", $form_url="", $secret_key="")
    {
       $this->setOrderTotal($order_total);
       $this->order_params = array(
           "sum" => $order_total,
           "clientid" => $clientid,
           "orderid" => $orderid,
           "client_email" => $client_email,
           "client_phone" => $client_phone,
           "phone" => $client_phone,
           "service_name" => $service_name,
           "form_url" => $form_url,
           "secret_key" => $secret_key,
       );
    }

    private function getOrderParams($value)
    {
        return array_key_exists($value, $this->order_params) ? $this->order_params["$value"] : False;
    }

    private function updateFiscalCart($ftype, $name="", $price=0, $quantity=0, $sum=0, $tax="none")
    {
        //update fz54 cart
        if ($ftype === "create") {
            $name = str_replace("\n ", "", $name);
            $name = str_replace("\r ", "", $name);
        }
        $this->fiscal_cart[] = array(
            "name" => $name,
            "price" => $price,
            "quantity" => $quantity,
            "sum" => $sum,
            "tax" => $tax
        );
    }

    private function getFiscalCart()
    {
        return $this->fiscal_cart;
    }

    private function setDiscounts($discount_enabled_flag)
    {
        $discount_modifier_value = 1;
        //set discounts
        if ($discount_enabled_flag) {

            if ($this->getFiscalCartSum(false) > 0)
                $discount_modifier_value = ($this->getOrderTotal() - $this->getShippingPrice())/$this->getFiscalCartSum(false);

            if ($discount_modifier_value < 1) {
                for ($pos=0; $pos<count($this->getFiscalCart()); $pos++) {//iterate fiscal cart without shipping
                    if ($pos != $this->delivery_index) {
                        $this->fiscal_cart[$pos]["sum"] *= $discount_modifier_value;
                        $this->fiscal_cart[$pos]["price"] = $this->fiscal_cart[$pos]["sum"]/$this->fiscal_cart[$pos]["quantity"];
                    }
                }
            }
        }
    }

    private function correctPrecision()
    {
        //handle possible precision problem
        $fiscal_cart_sum = $this->getFiscalCartSum(true);
        $total_sum = $this->getOrderTotal();
        $diff_sum = $total_sum - $fiscal_cart_sum;
        //debug_info
        //echo "\ntotal: $total_sum - cart: $fiscal_cart_sum - diff: $diff_sum";
        if (abs($diff_sum) <= 0.01) {
            if ($this->getUseDelivery()) { //delivery is used
                $this->correctPriceOfCartItem($diff_sum, count($this->fiscal_cart)-1);
            }
            else {
                if ($this->single_item_index >= 0) { //we got single cart element
                    $this->correctPriceOfCartItem($diff_sum, $this->single_item_index);
                }
                else if ($this->more_then_one_item_index >= 0) { //we got cart element with more then one quantity
                    $this->splitCartItem($this->more_then_one_item_index);
                    //add diff_sum to the last element (just separated) of fiscal cart
                    $this->correctPriceOfCartItem($diff_sum, count($this->fiscal_cart)-1);
                }
                else { //we only got cart elements with less than one quantity
                    $modify_value = ($diff_sum > 0) ? $total_sum/$fiscal_cart_sum : $fiscal_cart_sum/$total_sum;
                    for ($pos=0; $pos<count($this->getFiscalCart()); $pos++) {
                        $this->fiscal_cart[$pos]["sum"] *= $modify_value;
                        $this->fiscal_cart[$pos]["price"] = $this->fiscal_cart[$pos]["sum"]/$this->fiscal_cart[$pos]["quantity"];
                    }
                }
            }
        }
    }

    private function setOrderTotal($value)
    {
        $this->order_total = $value;
    }

    private function getOrderTotal()
    {
        return $this->order_total;
    }

    private function setShippingPrice($value)
    {
        $this->shipping_price = $value;
    }

    private function getShippingPrice()
    {
        return $this->shipping_price;
    }

    private function getPaymentFormType()
    {
        if (strpos($this->order_params["form_url"], "/order/inline") == True)
            return "order";
        else
            return "create";
    }

    private function setUseTaxes()
    {
        $this->use_taxes = True;
    }

    private function getUseTaxes()
    {
        return $this->use_taxes;
    }

    private function setUseDelivery()
    {
        $this->use_delivery = True;
    }

    private function getUseDelivery()
    {
        return $this->use_delivery;
    }

    private function setTaxes($tax_rate)
    {
        $taxes = array("tax" => "none", "tax_sum" => 0);
        switch(number_format($tax_rate, 0, ".", "")) {
            case 0:
                $taxes["tax"] = "vat0";
                break;
            case 10:
                $taxes["tax"] = "vat10";
                break;
            case 18:
                $taxes["tax"] = "vat18";
                break;
            case 20:
                $taxes["tax"] = "vat20";
                break;
        }
        return $taxes;
    }

    private function checkDeliveryIncluded($delivery_price, $delivery_name) {
        $index = 0;
        foreach ($this->getFiscalCart() as $item) {
            if ($item["name"] == $delivery_name
                && $item["price"] == $delivery_price
                && $item["quantity"] == 1) {
                $this->delivery_index = $index;
                return true;
            }
            $index++;
        }
        return false;
    }

    private function getFiscalCartSum($delivery_included) {
        $fiscal_cart_sum = 0;
        $index = 0;
        foreach ($this->getFiscalCart() as $item) {
            if (!$delivery_included && $index == $this->delivery_index)
                continue;
            $fiscal_cart_sum += $item["sum"];
            $index++;
        }
        return $fiscal_cart_sum;
    }

    private function showDebugInfo($obj_to_debug)
    {
        echo "<pre>";
        var_dump($obj_to_debug);
        echo "</pre>";
    }

    private function correctPriceOfCartItem($corr_price_to_add, $item_position)
    {
        $item_sum = 0;
        $this->fiscal_cart[$item_position]["price"] += $corr_price_to_add;
        $item_sum = $this->fiscal_cart[$item_position]["price"]*$this->fiscal_cart[$item_position]["quantity"];
        $this->fiscal_cart[$item_position]["sum"] = $item_sum;
    }

    private function splitCartItem($cart_item_position)
    {
        $item_sum = 0;
        $item_price = 0;
        $item_quantity = 0;
        $item_price = $this->fiscal_cart[$cart_item_position]["price"];
        $item_quantity = $this->fiscal_cart[$cart_item_position]["quantity"]-1;
        $this->fiscal_cart[$cart_item_position]["quantity"] = $item_quantity; //decreese quantity by one
        $this->fiscal_cart[$cart_item_position]["sum"] = $item_price*$item_quantity; //new sum
        //add one cart item to the end of cart
        $this->updateFiscalCart(
            $this->fiscal_cart[$cart_item_position]["name"],
            $item_price, 1, $item_price,
            $this->fiscal_cart[$cart_item_position]["tax"]);
    }
}
?>
