<?
require_once('paykeeper_common_class/paykeeper.class.php');
class nc_payment_system_paykeeper extends nc_payment_system {
    const ERROR_FORM_URL = NETCAT_MODULE_PAYMENT_PAYKEEPER_ERROR_FORM_URL;
    const ERROR_PRIVATE_SECURITY_KEY_IS_NULL = NETCAT_MODULE_PAYMENT_PAYKEEPER_ERROR_PRIVATE_SECURITY_KEY_IS_NULL;
    const ERROR_PRIVATE_SECURITY_IS_NOT_VALID = NETCAT_MODULE_PAYMENT_PAYKEEPER_ERROR_PRIVATE_SECURITY_IS_NOT_VALID;


    protected $automatic = TRUE;

    // принимаемые валюты
    protected $accepted_currencies = array('RUB', 'RUR', 'USD', 'EUR');
    protected $currency_map = array('RUR' => 'RUB');

    // параметры сайта в платежной системе
    protected $settings = array(
        'form_url' => null,
        'secret_key' => null,
        'forced_discount_check' => "0",
    );




    /**
     *
     */
    public function execute_payment_request(nc_payment_invoice $invoice) {


        ob_end_clean();


        $pk_obj = new PaykeeperPayment();

        $pk_obj -> setOrderParams
        (
            //sum
            $invoice->get_amount('%0.2F'),
            //clientid
            $invoice->get('customer_name'),
            //orderid
            $invoice->get_id(),
            //client_email
            $invoice->get('customer_email'),
            //client_phone
            $invoice->get('customer_phone'),
            //service_name
            '',
            //payment form url
            $this->get_setting('form_url'),
            //secret key
            $this->get_setting ('secret_key')
        );

        $cart_data =$invoice->get_items()->to_array(true) ;

        $item_index =0;

        foreach ($cart_data as $item) {

            $taxes = array("tax" => "none", "tax_sum" => 0);

            $tax_arr = array();

 		    $tax_rates =0;

            $name = $item['name'];

            //vat included in price
            $tax_amount =0;

            if ( (int)$item['vat_rate'] != 0) $tax_amount = $item['vat_rate'];


            $price = number_format($item['item_price'],2,'.','');

            $quantity = $item['qty'];

            if ($quantity == 1 && $pk_obj->single_item_index < 0)

                $pk_obj->single_item_index = $item_index;

            if ($quantity > 1 && $pk_obj->more_then_one_item_index < 0)

                $pk_obj->more_then_one_item_index = $item_index;

            $sum = number_format($price*$quantity,2,'.','');

            $taxes = $pk_obj->setTaxes($tax_amount);

	        $pk_obj->updateFiscalCart($pk_obj->getPaymentFormType(),

                $name, $price, $quantity, $sum, $taxes["tax"]);

                    $item_index++;
        }

        if ($this->get_setting('form_url')=='1')
        {

            $pk_obj->setDiscounts(true);

        }

        $pk_obj->correctPrecision();

        $fiscal_cart_encoded = json_encode($pk_obj->getFiscalCart());

        $form = "";

        if ($pk_obj->getPaymentFormType() == "create")
        {

            $to_hash = number_format($pk_obj->getOrderTotal(), 2, ".", "") .

                       $pk_obj->getOrderParams("clientid")     .

                       $pk_obj->getOrderParams("orderid")      .

                       $pk_obj->getOrderParams("service_name") .

                       $pk_obj->getOrderParams("client_email") .

                       $pk_obj->getOrderParams("client_phone") .

                       $pk_obj->getOrderParams("secret_key");

            $sign = hash ('sha256' , $to_hash);

            $form = '

            <h3>Сейчас Вы будете перенаправлены на страницу банка.</h3>

            <form name="payment" id="pay_form" action="'.$pk_obj->getOrderParams("form_url").'" accept-charset="utf-8" method="post">

            <input type="hidden" name="sum" value = "'.$pk_obj->getOrderTotal().'"/>

            <input type="hidden" name="orderid" value = "'.$pk_obj->getOrderParams("orderid").'"/>

            <input type="hidden" name="clientid" value = "'.$pk_obj->getOrderParams("clientid").'"/>

            <input type="hidden" name="client_email" value = "'.$pk_obj->getOrderParams("client_email").'"/>

            <input type="hidden" name="client_phone" value = "'.$pk_obj->getOrderParams("client_phone").'"/>

            <input type="hidden" name="service_name" value = "'.$pk_obj->getOrderParams("service_name").'"/>

            <input type="hidden" name="cart" value = \''.htmlentities($fiscal_cart_encoded,ENT_QUOTES).'\' />

            <input type="hidden" name="sign" value = "'.$sign.'"/>

            <input type="submit" id="button-confirm" value="Оплатить"/>

            </form>

            <script text="javascript">

            function sendForm() {

                document.getElementById("pay_form").submit();

            }
                sendForm();

             </script>';

        }

            else

        {
            $payment_parameters = array
            (
                "clientid"       => $pk_obj ->  getOrderParams("clientid"),

                "orderid"        => $pk_obj ->  getOrderParams('orderid'),

                "sum"            => $pk_obj ->  getOrderTotal(),

                "phone"          => $pk_obj ->  getOrderParams("phone"),

                "client_email"   => $pk_obj ->  getOrderParams("client_email"),

                "cart"           => $fiscal_cart_encoded);

                $query = http_build_query($payment_parameters);

                $query_options = array("http"=>array
                (
                    "method"=>"POST",
                    "header"=>"Content-type: application/x-www-form-urlencoded",
                    "content"=>$query
                )
            );

            $context = stream_context_create($query_options);

            if( function_exists( "curl_init" ))
            {

                $CR = curl_init();

                curl_setopt($CR, CURLOPT_URL, $pk_obj->getOrderParams("form_url"));

                curl_setopt($CR, CURLOPT_POST, 1);

                curl_setopt($CR, CURLOPT_FAILONERROR, true);

                curl_setopt($CR, CURLOPT_POSTFIELDS, $query);

                curl_setopt($CR, CURLOPT_RETURNTRANSFER, 1);

                curl_setopt($CR, CURLOPT_SSL_VERIFYPEER, 0);

                $result = curl_exec( $CR );

                $error = curl_error( $CR );

                if( !empty( $error ))
                {

                    $form = "<br/><span class=message>"."INTERNAL ERROR:".$error."</span>";

                    return false;

                }
                else
                {

                    $form = $result;

                }

                curl_close($CR);
            }

            else

            {

                if (!ini_get('allow_url_fopen'))

                {

                    $form_html = "<br/><span class=message>"."INTERNAL ERROR: Option allow_url_fopen is not set in php.ini"."</span>";

                }

                else

                {

                    $form = file_get_contents($pk_obj->getOrderParams("form_url"), false, $context);
                }

            }

        }
        if ($form  == "") $form = '<h3>Произошла ошибка при инциализации платежа</h3>';

        echo $form;
    }




    /**
     *
     */
    public function validate_payment_request_parameters() {
        if (!($this->get_setting('form_url'))) {
            $this->add_error(nc_payment_system_payonline::ERROR_MERCHANT_ID);
        }

        if (!($this->get_setting('secret_key'))) {
            $this->add_error(nc_payment_system_payonline::ERROR_PRIVATE_SECURITY_KEY_IS_NULL);
        }

    }

    /**
     * @param nc_payment_invoice $invoice
     */
    public function on_response(nc_payment_invoice $invoice = null) {

        $this->on_payment_success($invoice);


    }

    /**
     * @param nc_payment_invoice $invoice
     */
    public function validate_payment_callback_response(nc_payment_invoice $invoice = null) {


        if (empty($this->get_response_value('id')))

        {

            echo "Empty id!";

            exit();

        }

        if (empty($this->get_response_value('orderid')))

        {
            echo "Empty orderid!";

            exit();


        }


        $id = $this->get_response_value('id');

        $sum = $this->get_response_value('sum');

        $clientid = $this->get_response_value('clientid');

        $orderid = $this->get_response_value('orderid');

        $key = $this->get_response_value('key');

        $secret_seed = $this->get_setting('secret_key');


        if ($key!= md5($id . number_format($sum,2,'.','' ).$clientid.$orderid.$secret_seed))
        {

            $this->add_error(self::ERROR_PRIVATE_SECURITY_IS_NOT_VALID);

        }

        $this->on_payment_success($invoice);

        echo "OK ".md5($id.$secret_seed);
    }

    public function load_invoice_on_callback() {
        return $this->load_invoice($this->get_response_value('orderid'));
    }
}
