<?php

if (!defined('_VALID_MOS') && !defined('_JEXEC'))
    die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

if (!class_exists('vmPSPlugin'))
    require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');

class plgVmPaymentPayKeeper extends vmPSPlugin
{
    // instance of class
    public static $_this = false;

    private $fiscal_cart = array(); //fz54 cart
    private $order_total = 0; //order total sum
    private $shipping_price = 0; //shipping price
    private $use_taxes = false;
    private $use_delivery = false;
    private $order_params = NULL;
    private $discounts = array();

    
    function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
        
        $this->_loggable   = true;
        $this->tableFields = array_keys($this->getTableSQLFields());
        $varsToPush        = array(
            'payment_logos' => array(
                '',
                'char'
            ),
            'countries' => array(
                0,
                'int'
            ),
            'payment_order_total' => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\' ',
            'payment_currency' => array(
                0,
                'int'
            ),
            'min_amount' => array(
                0,
                'int'
            ),
            'max_amount' => array(
                0,
                'int'
            ),
            'cost_per_transaction' => array(
                0,
                'int'
            ),
            'cost_percent_total' => array(
                0,
                'int'
            ),
            'tax_id' => array(
                0,
                'int'
            ),
            'paykeeper_secret' => array(
                '',
                'string'
            ),
            'status_success' => array(
                '',
                'char'
            ),
            'status_pending' => array(
                '',
                'char'
            ),
            'status_canceled' => array(
                '',
                'char'
            ),
            'paykeeper_payment_form_url' => array(
                '',
                'string'
            )
        );

        
        $this->setConfigParameterable($this->_configTableFieldName, $varsToPush);
    }
    
    
    protected function getVmPluginCreateTableSQL()
    {
        return $this->createTableSQL('Payment PayKeeper Table');
    }
    
    function getTableSQLFields()
    {
        $SQLfields = array(
            'id' => 'tinyint(1) unsigned NOT NULL AUTO_INCREMENT',
            'virtuemart_order_id' => 'int(11) UNSIGNED DEFAULT NULL',
            'order_number' => 'char(32) DEFAULT NULL',
            'virtuemart_paymentmethod_id' => 'mediumint(1) UNSIGNED DEFAULT NULL',
            'payment_name' => 'char(255) NOT NULL DEFAULT \'\' ',
            'payment_order_total' => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\' ',
            'payment_currency' => 'char(3) ',
            'cost_per_transaction' => ' decimal(10,2) DEFAULT NULL ',
            'cost_percent_total' => ' decimal(10,2) DEFAULT NULL ',
            'tax_id' => 'smallint(11) DEFAULT NULL'
        );
        
        return $SQLfields;
    }
    
    function plgVmConfirmedOrder($cart, $order)
    {
        if (!($method = $this->getVmPluginMethod($order['details']['BT']->virtuemart_paymentmethod_id))) {
            return null; // Another method was selected, do nothing
        }
        if (!$this->selectedThisElement($method->payment_element)) {
            return false;
        }
        
        $lang     = JFactory::getLanguage();
        $filename = 'com_virtuemart';
        $lang->load($filename, JPATH_ADMINISTRATOR);
        $vendorId = 0;
        
        $session        = JFactory::getSession();
        $return_context = $session->getId();
        $this->logInfo('plgVmConfirmedOrder order number: ' . $order['details']['BT']->order_number, 'message');
        
        $html = "";
        
        if (!class_exists('VirtueMartModelOrders'))
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
        if (!$method->payment_currency)
            $this->getPaymentCurrency($method);
        // END printing out HTML Form code (Payment Extra Info)
        $q = 'SELECT `currency_code_3` FROM `#__virtuemart_currencies` WHERE `virtuemart_currency_id`="' . $method->payment_currency . '" ';
        $db =& JFactory::getDBO();
        $db->setQuery($q);
        $currency_code_3 = $db->loadResult();
        switch ($method->payment_currency) {
            case 144:
                $currency = 840;
                break;
            case 199:
                $currency = 980;
                break;
            case 164:
                $currency = 398;
                break;
            case 153:
                $currency = 710;
                break;
            default: {
                $currency                 = 643;
                $method->payment_currency = 131;
            };
        }
        $paymentCurrency        = CurrencyDisplay::getInstance($method->payment_currency);
        $totalInPaymentCurrency = round($paymentCurrency->convertCurrencyTo($method->payment_currency, $order['details']['BT']->order_total, false), 2);
        $cd                     = CurrencyDisplay::getInstance($cart->pricesCurrency);
        $virtuemart_order_id    = VirtueMartModelOrders::getOrderIdByOrderNumber($order['details']['BT']->order_number);
        
        $this->_virtuemart_paymentmethod_id      = $order['details']['BT']->virtuemart_paymentmethod_id;
        $dbValues['payment_name']                = $this->renderPluginName($method);
        $dbValues['order_number']                = $order['details']['BT']->order_number;
        $dbValues['virtuemart_paymentmethod_id'] = $this->_virtuemart_paymentmethod_id;
        $dbValues['cost_per_transaction']        = $method->cost_per_transaction;
        $dbValues['cost_percent_total']          = $method->cost_percent_total;
        $dbValues['payment_currency']            = $currency_code_3;
        $dbValues['payment_order_total']         = $totalInPaymentCurrency;
        $dbValues['tax_id']                      = $method->tax_id;
        $this->storePSPluginInternalData($dbValues);
        $params = array(
            "WMI_PAYMENT_AMOUNT" => $totalInPaymentCurrency,
            "WMI_CURRENCY_ID" => $currency,
            "WMI_PAYMENT_NO" => $virtuemart_order_id,
            "WMI_DESCRIPTION" => "BASE64:" . base64_encode('Оплата заказа ' . $order['details']['BT']->order_number),
            "WMI_SUCCESS_URL" => JROUTE::_(JURI::root() . 'index.php?option=com_virtuemart&view=orders&layout=details&order_number=' . $order['details']['BT']->order_number . '&order_pass=' . $order['details']['BT']->order_pass),
            "WMI_FAIL_URL" => JROUTE::_(JURI::root() . 'index.php?option=com_virtuemart&view=pluginresponse&task=pluginUserPaymentCancel&on=' . $order['details']['BT']->order_number . '&pm=' . $order['details']['BT']->virtuemart_paymentmethod_id)
        );
        foreach ($params as $name => $val) {
            if (is_array($val)) {
                usort($val, "strcasecmp");
                $params[$name] = $val;
            }
        }
        
        uksort($params, "strcasecmp");
        $fieldValues = "";
        
        foreach ($params as $value) {
            if (is_array($value))
                foreach ($value as $v) {
                    $v = iconv("utf-8", "windows-1251", $v);
                    $fieldValues .= $v;
                } else {
                $value = iconv("utf-8", "windows-1251", $value);
                $fieldValues .= $value;
            }
        }
        
        $signature = base64_encode(pack("H*", md5($fieldValues . $method->paykeeper_secret)));
        
        $params["WMI_SIGNATURE"] = $signature;


		$sum		= $order['details']['BT']->order_total;
		$clientid	= $order['details']['BT']->first_name . " " . $order['details']['BT']->last_name;
		$orderid	= $order['details']['BT']->virtuemart_order_id;
		$client_email 	= $order['details']['BT']->email;
		$phone 	= $order['details']['BT']->phone_1;
        $secret = $method->paykeeper_secret;
        $form_url = $method->paykeeper_payment_form_url;


        //set order parameters
        $this->setOrderParams($sum,             //sum
                              $clientid,        //clientid
                              $orderid,         //orderid
                              $client_email,    //client_email
                              $phone,           //client_phone
                              "",               //service_name
                              $form_url,        //payment form url
                              $secret           //secret key
        );

        //GENERATE FZ54 CART
        $product_cart_sum = 0;
        $tax = "none";
        $tax_sum = 0;
        $tax_value = 0;

        $cart_data = $order['items'];

        foreach ($cart_data as $product) {
            $name = $product->order_item_name;
            $price = $product->product_final_price;
            $quantity = $product->product_quantity;
            $sum = number_format($price*$quantity, 2, ".", "");
            $product_cart_sum += $sum;
            $tax_sum = $product->product_tax;
            $tax_value = $this->calculateTax($price, $tax_sum);

            switch($tax_value) {
                case 10:
                    $tax = "vat10";
                    $this->setUseTaxes();
                    break;
                case 18:
                    $tax = "vat18";
                    $this->setUseTaxes();
                    break;
            }

            $this->updateFiscalCart($this->getPaymentFormType(), 
                                     $name, $price, $quantity, $sum, $tax, $tax_sum);

            $tax = "none";
            $tax_sum = 0;
            $tax_value = 0;
        }

        //add shipping service
        $shipping_price = $order['details']['BT']->order_shipment;
        $shipping_tax = $order['details']['BT']->order_shipment_tax;
        $shipment_id = $order['details']['BT']->virtuemart_shipmentmethod_id;
        $shipping_name = VmModel::getModel('Shipmentmethod')->getShipment($shipment_id)->shipment_name;
        $this->setShippingPrice($shipping_price + $shipping_tax);

        if ($this->getShippingPrice() > 0) {
            $this->setUseDelivery();
            $shipping_tax_sum = ($this->getUseTaxes()) ? 
                                round((float)(($this->getShippingPrice()/118)*18), 2) : 0;
            $shipping_tax= ($this->getUseTaxes()) ? "vat18" : 0;
            $this->updateFiscalCart($this->getPaymentFormType(),
                                    ($shipping_name != "") ? $shipping_name : "Доставка",
                                    $this->getShippingPrice(), 1, 
                                    $this->getShippingPrice(), 
                                    $shipping_tax, $shipping_tax_sum);
        }

        $this->setDiscounts($order['details']['BT']->coupon_code, $product_cart_sum);

        //handle possible precision problem
        $this->correctPrecision($product_cart_sum);

        $fiscal_cart_encoded = json_encode($this->getFiscalCart());

        //generate payment form
        if ($this->getPaymentFormType() == "create") { //create form
            $to_hash = $this->getOrderTotal(True)                .
                       $this->getOrderParams("clientid")     .
                       $this->getOrderParams("orderid")      .
                       $this->getOrderParams("service_name") .
                       $this->getOrderParams("client_email") .
                       $this->getOrderParams("client_phone") .
                       $this->getOrderParams("secret");
            $sign = hash ('sha256' , $to_hash);
            $form = '
                <h3>Сейчас Вы будете перенаправлены на страницу банка.</h3> 
                <form name="payment" id="pay_form" action="'.$this->getOrderParams("form_url").'" accept-charset="utf-8" method="post">
                <input type="hidden" name="sum" value = "'.$this->getOrderTotal(True).'"/>
                <input type="hidden" name="orderid" value = "'.$this->getOrderParams("orderid").'"/>
                <input type="hidden" name="clientid" value = "'.$this->getOrderParams("clientid").'"/>
                <input type="hidden" name="client_email" value = "'.$this->getOrderParams("client_email").'"/>
                <input type="hidden" name="client_phone" value = "'.$this->getOrderParams("client_phone").'"/>
                <input type="hidden" name="service_name" value = "'.$this->getOrderParams("service_name").'"/>
                <input type="hidden" name="cart" value = '.$fiscal_cart_encoded.' />
                <input type="hidden" name="sign" value = "'.$sign.'"/>
                <input type="submit" class="btn btn-default" value="Оплатить"/>
                </form>
                <script type="text/javascript">
                window.onload=function(){
                    setTimeout(fSubmit, 2000);
                }
                function fSubmit() {
                    //document.forms["pay_form"].submit();
                }
                </script>';
        }
        else { //order form
            $payment_parameters = array(
                "sum"=>$this->getOrderTotal(), 
                "clientid"=>$this->getOrderParams("clientid"), 
                "orderid"=>$this->getOrderParams('orderid'), 
                "phone"=>$this->getOrderParams("phone"), 
                "client_email"=>$this->getOrderParams("client_email"), 
                "cart"=>$fiscal_cart_encoded);
            $query = http_build_query($payment_parameters);
            $err_num = $err_text = NULL;
            if( function_exists( "curl_init" )) { //using curl
                $CR = curl_init();
                curl_setopt($CR, CURLOPT_URL, $this->getOrderParams("form_url"));
                curl_setopt($CR, CURLOPT_POST, 1);
                curl_setopt($CR, CURLOPT_FAILONERROR, true); 
                curl_setopt($CR, CURLOPT_POSTFIELDS, $query);
                curl_setopt($CR, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($CR, CURLOPT_SSL_VERIFYPEER, 0);
                $result = curl_exec( $CR );
                $error = curl_error( $CR );
                if( !empty( $error )) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR:".$error."</span>";
                    return false;
                }
                else {
                    $form = $result;
                }
                curl_close($CR);
            }
            else { //using file_get_contents
                if (!ini_get('allow_url_fopen')) {
                    $form_html = "<br/><span class=message>"."INTERNAL ERROR: Option allow_url_fopen is not set in php.ini"."</span>";
                }
                else {
                    $form = file_get_contents($server, false, $context);
                }
            }
        }
        if ($form  == "") {
            $form = '<h3>Произошла ошибка при инциализации платежа</h3><p>$err_num: '.htmlspecialchars($err_text).'</p>';
        }

        return $this->processConfirmedOrderPaymentResponse(true, $cart, $order, $form, $this->renderPluginName($method, $order), 'P');
    }
    
    function plgVmOnShowOrderBEPayment($virtuemart_order_id, $virtuemart_payment_id)
    {
        if (!$this->selectedThisByMethodId($virtuemart_payment_id)) {
            return null; // Another method was selected, do nothing
        }
        
        $db = JFactory::getDBO();
        $q  = 'SELECT * FROM `' . $this->_tablename . '` ' . 'WHERE `virtuemart_order_id` = ' . $virtuemart_order_id;
        $db->setQuery($q);
        if (!($paymentTable = $db->loadObject())) {
            vmWarn(500, $q . " " . $db->getErrorMsg());
            return '';
        }
        $this->getPaymentCurrency($paymentTable);
        
        $html = '<table class="adminlist">' . "\n";
        $html .= $this->getHtmlHeaderBE();
        $html .= $this->getHtmlRowBE('STANDARD_PAYMENT_NAME', $paymentTable->payment_name);
        $html .= $this->getHtmlRowBE('STANDARD_PAYMENT_TOTAL_CURRENCY', $paymentTable->payment_order_total . ' ' . $paymentTable->payment_currency);
        $html .= '</table>' . "\n";
        return $html;
    }
    
    function getCosts(VirtueMartCart $cart, $method, $cart_prices)
    {
        if (preg_match('/%$/', $method->cost_percent_total)) {
            $cost_percent_total = substr($method->cost_percent_total, 0, -1);
        } else {
            $cost_percent_total = $method->cost_percent_total;
        }
        return ($method->cost_per_transaction + ($cart_prices['salesPrice'] * $cost_percent_total * 0.01));
    }
    
    protected function checkConditions($cart, $method, $cart_prices)
    {
        $address = (($cart->ST == 0) ? $cart->BT : $cart->ST);
        
        $amount      = $cart_prices['salesPrice'];
        $amount_cond = ($amount >= $method->min_amount AND $amount <= $method->max_amount OR ($method->min_amount <= $amount AND ($method->max_amount == 0)));
        if (!$amount_cond) {
            return false;
        }
        $countries = array();
        if (!empty($method->countries)) {
            if (!is_array($method->countries)) {
                $countries[0] = $method->countries;
            } else {
                $countries = $method->countries;
            }
        }
        
        // probably did not gave his BT:ST address
        if (!is_array($address)) {
            $address                          = array();
            $address['virtuemart_country_id'] = 0;
        }
        
        if (!isset($address['virtuemart_country_id']))
            $address['virtuemart_country_id'] = 0;
        if (count($countries) == 0 || in_array($address['virtuemart_country_id'], $countries) || count($countries) == 0) {
            return true;
        }
        
        return false;
    }
    
    function plgVmOnStoreInstallPaymentPluginTable($jplugin_id)
    {
        return $this->onStoreInstallPluginTable($jplugin_id);
    }
    
    public function plgVmOnSelectCheckPayment(VirtueMartCart $cart)
    {
        return $this->OnSelectCheck($cart);
    }
    
    public function plgVmDisplayListFEPayment(VirtueMartCart $cart, $selected = 0, &$htmlIn)
    {
        return $this->displayListFE($cart, $selected, $htmlIn);
    }
    
    public function plgVmonSelectedCalculatePricePayment(VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name)
    {
        return $this->onSelectedCalculatePrice($cart, $cart_prices, $cart_prices_name);
    }
    
    function plgVmgetPaymentCurrency($virtuemart_paymentmethod_id, &$paymentCurrencyId)
    {
        if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
            return null; // Another method was selected, do nothing
        }
        if (!$this->selectedThisElement($method->payment_element)) {
            return false;
        }
        $this->getPaymentCurrency($method);
        
        $paymentCurrencyId = $method->payment_currency;
    }
    
    function plgVmOnCheckAutomaticSelectedPayment(VirtueMartCart $cart, array $cart_prices = array())
    {
        return $this->onCheckAutomaticSelected($cart, $cart_prices);
    }
    
    public function plgVmOnShowOrderFEPayment($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name)
    {
        $this->onShowOrderFE($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
    }
    
    function plgVmonShowOrderPrintPayment($order_number, $method_id)
    {
        return $this->onShowOrderPrint($order_number, $method_id);
    }
    
    function plgVmDeclarePluginParamsPayment($name, $id, &$data)
    {
        return $this->declarePluginParams('payment', $name, $id, $data);
    }
    
    function plgVmSetOnTablePluginParamsPayment($name, $id, &$table)
    {
        return $this->setOnTablePluginParams($name, $id, $table);
    }
    
    protected function displayLogos($logo_list)
    {
        $img = "";
        
        if (!(empty($logo_list))) {
            $url = JURI::root() . str_replace(JPATH_ROOT, '', dirname(__FILE__)) . '/';
            if (!is_array($logo_list))
                $logo_list = (array) $logo_list;
            foreach ($logo_list as $logo) {
                $alt_text = substr($logo, 0, strpos($logo, '.'));
                $img .= '<img align="middle" src="' . $url . $logo . '"  alt="' . $alt_text . '" /> ';
            }
        }
        return $img;
    }
    
    public function plgVmOnPaymentNotification()
    {
        if (JRequest::getVar('pelement') != 'paykeeper') {
            return null;
        }
        if (!class_exists('VirtueMartModelOrders'))
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
        $orderid      = JRequest::getInt('WMI_PAYMENT_NO', 0);
        $postprice    = floatval(JRequest::getVar('WMI_PAYMENT_AMOUNT'));
        $payment      = $this->getDataByOrderId($orderid);
        $method       = $this->getVmPluginMethod($payment->virtuemart_paymentmethod_id);
        $order_model  = new VirtueMartModelOrders();
        $order_info   = $order_model->getOrder($orderid);
        $order_number = $order_info['details']['BT']->order_number;
        if (!$method->payment_currency)
            $this->getPaymentCurrency($method);
        // END printing out HTML Form code (Payment Extra Info)
        $q = 'SELECT `currency_code_3` FROM `#__virtuemart_currencies` WHERE `virtuemart_currency_id`="' . $method->payment_currency . '" ';
        $db =& JFactory::getDBO();
        $db->setQuery($q);
        $currency_code_3 = $db->loadResult();
        if (!class_exists('CurrencyDisplay'))
            require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'currencydisplay.php');
        $paymentCurrency        = CurrencyDisplay::getInstance($method->payment_currency);
        $totalInPaymentCurrency = round($paymentCurrency->convertCurrencyTo($method->payment_currency, $order_info['details']['BT']->order_total, false), 2);
        $sig                    = JRequest::getVar('WMI_SIGNATURE');
        $params                 = JRequest::get('post');
        unset($params["WMI_SIGNATURE"]);
        uksort($params, "strcasecmp");
        $values    = implode('', $params);
        $signature = base64_encode(pack("H*", md5($values . $method->paykeeper_secret)));
        if ($totalInPaymentCurrency == $postprice && $sig == $signature) {
            switch (JRequest::getVar('WMI_ORDER_STATE')) {
                case 'Accepted':
                    $status = $method->status_success;
                    $msg    = 'оплачен';
                    break;
                case 'Rejected':
                default:
                    $status = $method->status_canceled;
                    $msg    = 'отменён';
                    break;
            }
            $order['order_status']        = $status;
            $order['virtuemart_order_id'] = $orderid;
            $order['customer_notified']   = 0;
            $order['comments']            = JTExt::sprintf('VMPAYMENT_PAYKEEPER_PAYMENT_CONFIRMED', $order_number);
            if (!class_exists('VirtueMartModelOrders'))
                require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
            $modelOrder = new VirtueMartModelOrders();
            ob_start();
            $modelOrder->updateStatusForOneOrder($orderid, $order, true);
            ob_end_clean();
            echo 'WMI_RESULT=OK';
            exit();
        }
        echo 'WMI_RESULT=RETRY&WMI_DESCRIPTION=' . urlencode('Неверная подпись заказа');
        return null;
    }
    
    function plgVmOnPaymentResponseReceived(&$html)
    {
        // the payment itself should send the parameter needed;
        
        $virtuemart_paymentmethod_id = JRequest::getInt('pm', 0);
        
        $vendorId = 0;
        if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
            return null; // Another method was selected, do nothing
        }
        if (!$this->selectedThisElement($method->payment_element)) {
            return false;
        }
        
        if (!class_exists('VirtueMartModelOrders'))
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
        
        $order_number        = JRequest::getVar('on');
        $virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number);
        $payment_name        = $this->renderPluginName($method);
        $html                = '<table>' . "\n";
        $html .= $this->getHtmlRow('PAYKEEPER_PAYMENT_NAME', $payment_name);
        $html .= $this->getHtmlRow('PAYKEEPER_ORDER_NUMBER', $virtuemart_order_id);
        $html .= $this->getHtmlRow('PAYKEEPER_STATUS', JText::_('VMPAYMENT_PAYKEEPER_STATUS_SUCCESS'));
        
        $html .= '</table>' . "\n";
        
        if ($virtuemart_order_id) {
            if (!class_exists('VirtueMartCart'))
                require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
            // get the correct cart / session
            $cart = VirtueMartCart::getCart();
            
            // send the email ONLY if payment has been accepted
            if (!class_exists('VirtueMartModelOrders'))
                require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
            $order      = new VirtueMartModelOrders();
            $orderitems = $order->getOrder($virtuemart_order_id);
            $cart->sentOrderConfirmedEmail($orderitems);
            $cart->emptyCart();
        }
        
        return true;
    }
    
    function plgVmOnUserPaymentCancel()
    {
        if (!class_exists('VirtueMartModelOrders'))
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
        
        $order_number = JRequest::getVar('on');
        if (!$order_number)
            return false;
        $db    = JFactory::getDBO();
        $query = 'SELECT ' . $this->_tablename . '.`virtuemart_order_id` FROM ' . $this->_tablename . " WHERE  `order_number`= '" . $order_number . "'";
        
        $db->setQuery($query);
        $virtuemart_order_id = $db->loadResult();
        
        if (!$virtuemart_order_id) {
            return null;
        }
        $this->handlePaymentUserCancel($virtuemart_order_id);
        
        return true;
    }

    private function notifyCustomer($order, $order_info)
    {
        $lang     = JFactory::getLanguage();
        $filename = 'com_virtuemart';
        $lang->load($filename, JPATH_ADMINISTRATOR);
        if (!class_exists('VirtueMartControllerVirtuemart'))
            require(JPATH_VM_SITE . DS . 'controllers' . DS . 'virtuemart.php');
        
        if (!class_exists('shopFunctionsF'))
            require(JPATH_VM_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
        $controller = new VirtueMartControllerVirtuemart();
        $controller->addViewPath(JPATH_VM_ADMINISTRATOR . DS . 'views');
        
        $view = $controller->getView('orders', 'html');
        if (!$controllerName)
            $controllerName = 'orders';
        $controllerClassName = 'VirtueMartController' . ucfirst($controllerName);
        if (!class_exists($controllerClassName))
            require(JPATH_VM_SITE . DS . 'controllers' . DS . $controllerName . '.php');
        
        $view->addTemplatePath(JPATH_COMPONENT_ADMINISTRATOR . '/views/orders/tmpl');
        
        $db = JFactory::getDBO();
        $q  = "SELECT CONCAT_WS(' ',first_name, middle_name , last_name) AS full_name, email, order_status_name
			FROM #__virtuemart_order_userinfos
			LEFT JOIN #__virtuemart_orders
			ON #__virtuemart_orders.virtuemart_user_id = #__virtuemart_order_userinfos.virtuemart_user_id
			LEFT JOIN #__virtuemart_orderstates
			ON #__virtuemart_orderstates.order_status_code = #__virtuemart_orders.order_status
			WHERE #__virtuemart_orders.virtuemart_order_id = '" . $order['virtuemart_order_id'] . "'
			AND #__virtuemart_orders.virtuemart_order_id = #__virtuemart_order_userinfos.virtuemart_order_id";
        $db->setQuery($q);
        $db->query();
        $view->user  = $db->loadObject();
        $view->order = $order;
        JRequest::setVar('view', 'orders');
        $user = $this->sendVmMail($view, $order_info['details']['BT']->email, false);
        if (isset($view->doVendor)) {
            $this->sendVmMail($view, $view->vendorEmail, true);
        }
    }

    private function sendVmMail(&$view, $recipient, $vendor = false)
    {
        ob_start();
        $view->renderMailLayout($vendor, $recipient);
        $body = ob_get_contents();
        ob_end_clean();
        
        $subject = (isset($view->subject)) ? $view->subject : JText::_('COM_VIRTUEMART_DEFAULT_MESSAGE_SUBJECT');
        $mailer  = JFactory::getMailer();
        $mailer->addRecipient($recipient);
        $mailer->setSubject($subject);
        $mailer->isHTML(VmConfig::get('order_mail_html', true));
        $mailer->setBody($body);
        
        if (!$vendor) {
            $replyto[0] = $view->vendorEmail;
            $replyto[1] = $view->vendor->vendor_name;
            $mailer->addReplyTo($replyto);
        }
        
        if (isset($view->mediaToSend)) {
            foreach ((array) $view->mediaToSend as $media) {
                $mailer->addAttachment($media);
            }
        }
        return $mailer->Send();
    }
    
    private function setOrderParams($order_total = 0, $clientid="", $orderid="", $client_email="", 
                                    $client_phone="", $service_name="", $form_url="", $secret_key="")
    {
       $this->setOrderTotal($order_total);
       $this->order_params = array(
           "sum" => $order_total,
           "clientid" => $clientid,
           "orderid" => $orderid,
           "client_email" => $client_email,
           "client_phone" => $client_phone,
           "phone" => $phone,
           "service_name" => $service_name,
           "form_url" => $form_url,
           "secret" => $secret_key,
       );
    }

    private function getOrderParams($value)
    {
        return array_key_exists($value, $this->order_params) ? $this->order_params["$value"] : False;
    }

    private function updateFiscalCart($ftype, $name="", $price=0, $quantity=0, $sum=0, $tax="none", $tax_sum=0)
    {
        //update fz54 cart
        if ($ftype === "create") {
            $name = str_replace("\n ", "", $name);
            $name = str_replace("\r ", "", $name);
            $name = str_replace(" ", "&nbsp;", $name);
            $name = preg_replace('/"{1,}/','\'',$name);
            $name = htmlspecialchars($name);
        }
        $this->fiscal_cart[] = array(
            "name" => $name,
            "price" => $price,
            "quantity" => $quantity,
            "sum" => $sum,
            "tax" => $tax,
            "tax_sum" => number_format($tax_sum, 2, ".", "")
        );
    }

    private function getFiscalCart()
    {
        return $this->fiscal_cart;
    }

    private function setDiscounts($coupon_code, $product_cart_sum)
    {
        //set discounts
        if ($coupon_code != NULL) {
            $order_sum_with_discount = $this->getOrderTotal() - $this->getShippingPrice();
            if ($product_cart_sum > $order_sum_with_discount) {
                $discount_percent = ($product_cart_sum - $order_sum_with_discount) / ($product_cart_sum/100);
                $product_cart_count = ($this->getShippingPrice() > 0) ? 
                                      count($this->getFiscalCart())-1 : 
                                      count($this->getFiscalCart());
                for ($pos=0; $pos<$product_cart_count; $pos++) {
                    $this->fiscal_cart[$pos]["sum"] -= $this->fiscal_cart[$pos]["sum"]/100*$discount_percent;
                    $this->fiscal_cart[$pos]["price"] = $this->fiscal_cart[$pos]["sum"]/$this->fiscal_cart[$pos]["quantity"];
                    //formatting
                    $this->fiscal_cart[$pos]["price"] = number_format($this->fiscal_cart[$pos]["price"], 3, ".", "");
                    $this->fiscal_cart[$pos]["sum"] = number_format($this->fiscal_cart[$pos]["sum"], 2, ".", "");

                    //recalculate taxes
                    $this->recalculateTaxes($pos);
                }
            }
        }
    }

    private function correctPrecision($cart_sum)
    {
        //handle possible precision problem
        $fiscal_cart_sum = $cart_sum;
        $total_sum = number_format($this->getOrderTotal(), 2, ".", "");
        //add shipping sum to cart sum
        if ($this->getShippingPrice() > 0)
            $fiscal_cart_sum += $this->getShippingPrice();
        //debug_info
        //echo "total: " . $total_sum . " - cart: " . $cart_sum;
        $diff_sum = $fiscal_cart_sum - $total_sum;
        if (abs($diff_sum) <= 0.01) {
            $this->setOrderTotal(number_format($total_sum+$diff_sum, 2, ".", ""));
        }
        else {
            if ($this->getUseDelivery() && ($fiscal_cart_sum < $total_sum)) {
                $this->setOrderTotal(number_format($total_sum+$diff_sum, 2, ".", ""));
                $delivery_pos = count($this->getFiscalCart())-1;
                $this->fiscal_cart[$delivery_pos]["price"] = number_format(
                                   $this->fiscal_cart[$delivery_pos]["price"]+$diff_sum, 2, ".", "");
                $this->fiscal_cart[$delivery_pos]["sum"] = number_format(
                                   $this->fiscal_cart[$delivery_pos]["sum"]+$diff_sum, 2, ".", "");
                $this->recalculateTaxes($delivery_pos);
            }
        }
    }

    private function setOrderTotal($value)
    {
        $this->order_total = $value;
    }

    private function getOrderTotal($format=False)
    {
        return ($format) ? number_format($this->order_total, 2, ".", "") : 
                                         $this->order_total;
    }

    private function setShippingPrice($value)
    {
        $this->shipping_price = $value;
    }

    private function getShippingPrice()
    {
        return $this->shipping_price;
    }

    private function getPaymentFormType()
    {
        if (strpos($this->order_params["form_url"], "/order/inline") == True)
            return "order";
        else
            return "create";
    }

    private function setUseTaxes()
    {
        $this->use_taxes = True;
    }

    private function getUseTaxes()
    {
        return $this->use_taxes;
    }

    private function setUseDelivery()
    {
        $this->use_delivery = True;
    }

    private function getUseDelivery()
    {
        return $this->use_delivery;
    }

    private function calculateTax($product_price, $product_tax_sum)
    {
        return number_format($product_tax_sum/(($product_price-$product_tax_sum)/100), 0, ".", "");
    }

    private function recalculateTaxes($item_pos)
    {
        //recalculate taxes
        switch($this->fiscal_cart[$item_pos]['tax']) {
            case "vat10":
                $this->fiscal_cart[$item_pos]['tax_sum'] = round((float)
                    (($this->fiscal_cart[$item_pos]['sum']/110)*10), 2);
                break;
            case "vat18":
                $this->fiscal_cart[$item_pos]['tax_sum'] = round((float)
                    (($this->fiscal_cart[$item_pos]['sum']/118)*18), 2);
                break;
        }
    }
}
?>
