/**
 * Plugin PayKeeper
 *
 * @var modX $modx
 * @var int $order_id
 *
 * System event: OnSHKsaveOrder
 */
switch ($modx->event->name) {
    case 'OnSHKsaveOrder':
        if (isset($_REQUEST['payment']) && $_REQUEST['payment'] === 'paykeeper') {
            if (!$order_id) {
                $modx->log(modX::LOG_LEVEL_ERROR, 'Order ID is missing.');
                return false;
            }

            $order = $modx->getObject('SHKorder', array('id' => $order_id));
            if (!$order) {
                $modx->log(modX::LOG_LEVEL_ERROR, 'Order not found.');
                return false;
            }

            // Преобразование объекта заказа в массив
            $orderArray = $order->toArray();

            // Сохранение информации о заказе в сессии
            $_SESSION['shk_lastOrder'] = $orderArray;
            $_SESSION['shk_order_id'] = $order_id;

            $snippet = $modx->getObject('modSnippet',array('name' => 'Paykeeper'));
            $config = $snippet->getProperties();
            $paymentPageId = $modx->getOption('PK_PAYMENT_FORM_ID', $config, null);
            $modx->sendRedirect($modx->makeUrl($paymentPageId));
        }
}
return true;