<?php

/**
 * PayKeeper
 *
 * @var modX $modx
 * @var array $scriptProperties
 *
 * @package paykeeper
 */
//debug
//error_reporting(E_ALL);
//ini_set("display_errors", 0);
//ini_set('log_errors','on');
//ini_set('error_log', __DIR__ . 'paykeeper.error.log');

require_once(MODX_CORE_PATH.'components/paykeeper/paykeeper.class.php');

$modx->addPackage(
    'shopkeeper',
    $modx->getOption('core_path') . 'components/shopkeeper/model/'
);

if (isset($_REQUEST['payment']) && $_REQUEST['payment'] === 'paykeeper') {
    $paymentPageId = $modx->getOption('PK_PAYMENT_FORM_ID', $scriptProperties, null);
    $modx->sendRedirect($modx->makeUrl($paymentPageId));
}

if (isset($scriptProperties['action'])) {
    $PaykeeperPayment = new PaykeeperPayment();

    $arrStatuses = [
        'New' => 0,
        'Pending' => 1,
        'Accept' => 2,
        'Success' => 3,
        'Fail' => 4,
        'Paid' => 5
    ];

    switch ($scriptProperties['action']) {
        case 'payment':
            if (isset($_SESSION['shk_order_id'])) {
                $order_id = $_SESSION['shk_order_id'];
            } elseif (isset($_REQUEST['order_id'])) {
                $order_id = $_REQUEST['order_id'];
            } elseif (isset($_SESSION['shk_lastOrder']['id'])) {
                $order_id = $_SESSION['shk_lastOrder']['id'];
            }

            if (!isset($order_id)) {
                $modx->log(modX::LOG_LEVEL_ERROR, 'Order ID is missing.');
                return 'Order ID is missing.';
            }

            $order = $modx->getObject('SHKorder', array('id' => $order_id));
            if (!$order) {
                $modx->log(modX::LOG_LEVEL_ERROR, 'Order not found.');
                return 'Order not found.';
            }

            //$orderStatus = $order->get('status');
            $contacts = unserialize($order->get('contacts'));

            // Формируем параметры формы оплаты
            $PaykeeperPayment->setOrderParams(
                //sum
                number_format($order->get('price'), 2, '.', ''),
                //clientid
                $contacts['fullname'],
                //orderid
                $order_id,
                //client_email
                $order->get('email'),
                //client_phone
                $order->get('phone'),
                //service_name
                '',
                //payment form url
                $modx->getOption('PK_PAYMENT_FORM_URL', $scriptProperties, null),
                //secret key
                $modx->getOption('PK_SECRET_SEED', $scriptProperties, null)
            );


            // Формируем корзину
            $shippingMethod = null;
            $shippingPrice = 0;
            $paymentFormType = $PaykeeperPayment->getPaymentFormType();
            if ($content = unserialize($order->get('content'))) {
                $goodsTax = $modx->getOption('PK_VAT_GOODS', $scriptProperties, 'none');
                $goodsTax = ( !is_numeric($goodsTax) ? 'none' : ('vat'.intval($goodsTax)) );
                foreach ($content as $item) {
                    if ($item['price'] > 0) {
                        $PaykeeperPayment->updateFiscalCart(
                            $paymentFormType,
                            $item['name'],
                            $item['price'],
                            $item['count'],
                            $goodsTax
                        );
                    } elseif (isset($item['tv_add']['shk_delivery'])) {
                        $shippingMethod = $item['tv_add']['shk_delivery'];
                    }
                }
            }

            // Получаем стоимость доставки
            if (!empty($shippingMethod)) {
                foreach (unserialize($order->get('addit')) as $items) {
                    foreach ($items as $item) {
                        if (isset($item[0]) && $item[0] === $shippingMethod) {
                            $shippingPrice = $item[1];
                        }
                    }
                }
            }

            // Добавляем доставку в корзину
            if ($shippingMethod && $shippingPrice > 0) {
                $servicesTax = $modx->getOption('PK_VAT_SERVICE', $scriptProperties, 'none');
                $servicesTax = ( !is_numeric($servicesTax) ? 'none' : ('vat'.intval($servicesTax)) );
                $PaykeeperPayment->updateFiscalCart(
                    $paymentFormType,
                    $shippingMethod,
                    $shippingPrice,
                    1,
                    $servicesTax,
                    'service'
                );
            }

            // Уравниваем общую стоимость с корзиной
            if($PaykeeperPayment->getFiscalCart()){
                $PaykeeperPayment->correctPrecision();
            }

            $toHash = $PaykeeperPayment->getOrderTotal().
                $PaykeeperPayment->getOrderParams("clientid")     .
                $PaykeeperPayment->getOrderParams("orderid")      .
                $PaykeeperPayment->getOrderParams("service_name") .
                $PaykeeperPayment->getOrderParams("client_email") .
                $PaykeeperPayment->getOrderParams("client_phone") .
                $PaykeeperPayment->getOrderParams("secret_key");
            $sign = hash ('sha256' , $toHash);

            $paykeeperForm = $PaykeeperPayment->getDefaultPaymentForm($sign);

            $order->set('status', $modx->getOption('PK_STATUS_PENDING', $scriptProperties, $arrStatuses['Pending']));
            $order->save();

            return $paykeeperForm;

        case 'callback':
            $arrRequest = !empty($_POST) ? $_POST : $_GET;

            if (empty($arrRequest['key'])) {
                $modx->log(modX::LOG_LEVEL_ERROR, 'Request is not properly signed.');
                return 'Request is not properly signed.';
            }

            $secretSeed = $scriptProperties['PK_SECRET_SEED'];
            $id = $arrRequest['id'];
            $sum = $arrRequest['sum'];
            $clientId = $arrRequest['clientid'];
            $orderId = $arrRequest['orderid'];
            $key = $arrRequest['key'];

            if ($key !== md5($id . sprintf('%.2lf', $sum) . $clientId . $orderId . $secretSeed)) {
                $modx->log(modX::LOG_LEVEL_ERROR, 'Wrong signature.');
                return 'Wrong signature.';
            }

            $order = $modx->getObject('SHKorder', array('id' => $orderId));
            $bCheckResult = 1;
            $errorDesc = '';

            if (empty($order)) {
                $modx->log(modX::LOG_LEVEL_ERROR, 'Order is empty.');
                return 'Order is empty.';
            }

            if ($order->get('status') != $arrStatuses['Pending']) {
                $modx->log(modX::LOG_LEVEL_ERROR, "Error status {$order->get('status')}.");
                return "Error status {$order->get('status')}.";
            }

            if (sprintf('%0.2f', $sum) !== sprintf('%0.2f', $order->get('price'))) {
                $modx->log(modX::LOG_LEVEL_ERROR, "Error sum {$order->get('price')}.");
                return "Error sum {$order->get('price')}.";
            }

            $sResponse = 'OK ' . md5($id . $secretSeed);
            $order->set('status', $arrStatuses['Paid']);
            $order->set('status', $modx->getOption('PK_STATUS_PAID', $scriptProperties, $arrStatuses['Paid']));
            $order->save();
            return 'OK ' . md5($id . $secretSeed);
    }
}
