<?php
class Smarty_Tmgco_Block_Redirect extends Mage_Core_Block_Template
{
    /**
     * Return checkout session instance
     *
     * @return Mage_Checkout_Model_Session
     */
    protected function _getCheckout()
    {
        return Mage::getSingleton('checkout/session');
    }

    /**
     * Return order instance
     *
     * @return Mage_Sales_Model_Order|null
     */
    protected function _getOrder()
    {
        if ($this->getOrder()) {
            return $this->getOrder();
        } elseif ($orderIncrementId = $this->_getCheckout()->getLastRealOrderId()) {
            return Mage::getModel('sales/order')->loadByIncrementId($orderIncrementId);
        } else {
            return null;
        }
    }

    public function getFormHTMLContent ()
    {
        $params = $this->_getOrder()->getPayment()->getMethodInstance()->getFormFields();
        $query_params = $params['params'];
        if ($params["form_type"] == "create") { //create form
            $form = '
                <h3>Сейчас Вы будете перенаправлены на страницу банка.</h3> 
                <form name="payment" id="pay_form" action="'.$params["form_url"].'" accept-charset="utf-8" method="post">
                <input type="hidden" name="sum" value = "'.$query_params["sum"].'"/>
                <input type="hidden" name="orderid" value = "'.$query_params["orderid"].'"/>
                <input type="hidden" name="clientid" value = "'.$query_params["clientid"].'"/>
                <input type="hidden" name="client_email" value = "'.$query_params["client_email"].'"/>
                <input type="hidden" name="client_phone" value = "'.$query_params["client_phone"].'"/>
                <input type="hidden" name="service_name" value = "'.$query_params["service_name"].'"/>
                <input type="hidden" name="cart" value = '.$query_params["cart"].' />
                <input type="hidden" name="sign" value = "'.$query_params["sign"].'"/>
                <input type="submit" class="button" value="Оплатить"/>
                </form>
                <script type="text/javascript">
                window.onload=function(){
                    setTimeout(fSubmit, 2000);
                }
                function fSubmit() {
                    document.forms["pay_form"].submit();
                }
                </script>';
        }
        else { //order form
            //debug info
            $payment_parameters = array(
                "sum"=>$query_params["sum"], 
                "clientid"=>$query_params["clientid"], 
                "orderid"=>$query_params["orderid"], 
                "phone"=>$query_params["phone"], 
                "client_email"=>$query_params["client_email"], 
                "cart"=>$query_params["cart"]);
            $query = http_build_query($payment_parameters);
            $err_num = $err_text = NULL;
            if( function_exists( "curl_init" )) { //using curl
                $CR = curl_init();
                curl_setopt($CR, CURLOPT_URL, $params["form_url"]);
                curl_setopt($CR, CURLOPT_POST, 1);
                curl_setopt($CR, CURLOPT_FAILONERROR, true); 
                curl_setopt($CR, CURLOPT_POSTFIELDS, $query);
                curl_setopt($CR, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($CR, CURLOPT_SSL_VERIFYPEER, 0);
                $result = curl_exec( $CR );
                $error = curl_error( $CR );
                if( !empty( $error )) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR:".$error."</span>";
                    return false;
                }
                else {
                    $form = $result;
                }
                curl_close($CR);
            }
            else { //using file_get_contents
                if (!ini_get('allow_url_fopen')) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR: Option allow_url_fopen is not set in php.ini"."</span>";
                }
                else {
                    $form = file_get_contents($server, false, $context);
                }
            }
        }
        if ($form  == "") {
            $form = '<h3>Произошла ошибка при инциализации платежа</h3><p>$err_num: '.htmlspecialchars($err_text).'</p>';
        }
        
        return $form;

    }

    /**
     * Get form data
     *
     * @return array
     */
    public function getFormData()
    {
        return $this->_getOrder()->getPayment()->getMethodInstance()->getFormFields();
    }

    /**
     * Getting url of payment form
     *
     * @return string
     */
    public function getFormAction()
    {
        return $this->_getOrder()->getPayment()->getMethodInstance()->getUrl();
    }
}
