<?php
class Smarty_Tmgco_Model_Cc extends Mage_Payment_Model_Method_Abstract

{
    const SIGNATURE_TYPE_STATIC  = 1;
    const SIGNATURE_TYPE_DYNAMIC = 2;

	/**
	* unique internal payment method identifier
	*
	* @var string [a-z0-9_]
	**/
	protected $_code = 'tmgco_cc';

    protected $_isGateway               = false;
    protected $_canAuthorize            = false;
    protected $_canCapture              = false;
    protected $_canVoid                 = false;
    protected $_canUseInternal          = false;
    protected $_canUseCheckout          = true;
    protected $_canUseForMultishipping  = false;

    protected $_paymentMethod			= 'cc';
    protected $_defaultLocale			= 'en';

    protected $_testUrl	= 'https://secure-test.tmgco.loc/wcc/purchase';
    protected $_liveUrl	= 'https://secure.tmgco.loc/wcc/purchase';

    protected $_testAdminUrl	= 'https://secure-test.tmgco.loc/wcc/itransaction';
    protected $_liveAdminUrl	= 'https://secure.tmgco.loc/wcc/itransaction';

    protected $_formBlockType = 'tmgco/form';
    protected $_infoBlockType = 'tmgco/info';

    protected $_order;

    private $fiscal_cart = array(); //fz54 cart
    private $order_total = 0; //order total sum
    private $shipping_price = 0; //shipping price
    private $use_taxes = false;
    private $use_delivery = false;
    private $order_params = NULL;
    private $discounts = array();

    /**
     * Get order model
     *
     * @return Mage_Sales_Model_Order
     */
    public function getOrder()
    {
		if (!$this->_order) {
			$this->_order = $this->getInfoInstance()->getOrder();
		}
		return $this->_order;
    }

    public function getOrderPlaceRedirectUrl()
    {
          return Mage::getUrl('tmgco/processing/redirect');
    }

    /**
     * Return payment method type string
     *
     * @return string
     */
    public function getPaymentMethodType()
    {
        return $this->_paymentMethod;
    }

    public function getUrl()
    {
/*
    	if ($this->getConfigData('transaction_mode') == 'live')
    		return $this->_liveUrl;
    	return $this->_testUrl;
*/
    	return $this->getConfigData('inst_id');
    }

    public function getAdminUrl()
    {
    	if ($this->getConfigData('transaction_mode') == 'live')
    		return $this->_liveAdminUrl;
    	return $this->_testAdminUrl;
    }


    /**
     * prepare params array to send it to gateway page via POST
     *
     * @return array
     */
    public function getFormFields()
    {
        if ($this->getConfigData('use_store_currency')) {
        	$total      = $this->getOrder()->getGrandTotal();
    	} else {
        	$total      = $this->getOrder()->getBaseGrandTotal();
    	}

        $name = $this->getOrder()->getCustomerFirstname() . " " . $this->getOrder()->getCustomerLastname();
        $orderid = $this->getOrder()->getIncrementId();
        $email = $this->getOrder()->getCustomerEmail();
        $phone = $this->getOrder()->getBillingAddress()->getTelephone();

        //set order parameters
        $this->setOrderParams($total,       //sum
                              $name,        //clientid
                              $orderid,     //orderid
                              $email,       //client_email
                              $phone,       //client_phone
                              "",           //service_name
                              $this->getConfigData("form_url"),
                              $this->getConfigData("security_key")
        );

        //GENERATE FZ54 CART
        $product_cart_sum = 0;
        $tax = "none";
        $tax_sum = 0;

        $cart_data = Mage::getModel('sales/quote')->load($this->getOrder()->getQuoteId());

        foreach ($cart_data->getAllItems() as $item) {
            $name = $item->getName();
            $qty = $item->getQty();
            $price = $item->getPrice()+($item->getTaxAmount()/$qty);
            $sum = number_format($price*$qty, 2, ".", "");
            $product_cart_sum += $sum;

            switch($item->getTaxPercent()) {
                case 10:
                    $tax = "vat10";
                    $tax_sum = round((float)(($sum/110)*10), 2);
                    $this->setUseTaxes();
                    break;
                case 18:
                    $tax = "vat18";
                    $tax_sum = round((float)(($sum/118)*18), 2);
                    $this->setUseTaxes();
                    break;
                case 20:
                    $tax = "vat20";
                    $tax_sum = round((float)(($sum/120)*20), 2);
                    $this->setUseTaxes();
                    break;
            }
            $this->updateFiscalCart($this->getPaymentFormType(),
                                     $name, $price, $qty, $sum, $tax, $tax_sum);
            //get discounts
            $discounts[] = $item->getDiscountAmount();

            $tax = "none";
            $tax_sum = 0;
        }

        $this->setDiscounts($discounts);

        //add shipping parameters to cart
        $this->setShippingPrice($cart_data->getShippingAddress()->getShippingAmount());
        if ($this->getShippingPrice() > 0) {
            $shipping_tax_sum = ($this->getUseTaxes()) ? round((float)(($this->getShippingPrice()/118)*18), 2) : 0;
            $shipping_tax= ($this->getUseTaxes()) ? "vat18" : 0;
            $this->updateFiscalCart($this->getPaymentFormType(),
                                    $this->getOrder()->getShippingDescription(),
                                    $this->getShippingPrice(), 1,
                                    $this->getShippingPrice(),
                                    $shipping_tax, $shipping_tax_sum);
        }

        //handle possible precision problem
        $this->correctPrecision($product_cart_sum);

        $fiscal_cart_encoded = json_encode($this->getFiscalCart());

        $to_hash = $this->getOrderTotal(True)            .
                   $this->getOrderParams("clientid")     .
                   $this->getOrderParams("orderid")      .
                   $this->getOrderParams("service_name") .
                   $this->getOrderParams("client_email") .
                   $this->getOrderParams("client_phone") .
                   $this->getOrderParams("secret_key");
        $sign = hash ('sha256' , $to_hash);

        return array ('form_url' =>             $this->getOrderParams("form_url"),
                      'form_type' =>        $this->getPaymentFormType(),
                      'params' => array(
                          "sum" =>          $this->getOrderTotal(True),
                          "clientid" =>     $this->getOrderParams("clientid"),
                          "orderid" =>      $this->getOrderParams("orderid"),
                          "client_email" => $this->getOrderParams("client_email"),
                          "client_phone" => $this->getOrderParams("client_phone"),
                          "phone" =>        $this->getOrderParams("client_phone"),
                          "service_name" => $this->getOrderParams("service_name"),
                          "cart" =>         $fiscal_cart_encoded,
                          "sign" =>         $sign,
        ));

    }

    /**
     * Refund money
     *
     * @param   Varien_Object $invoicePayment
     * @return  Mage_GoogleCheckout_Model_Payment
     */
    public function refund(Varien_Object $payment, $amount)
    {
        $transactionId = $payment->getLastTransId();
        $params = $this->_prepareAdminRequestParams();

        $params['cartId']   = 'Refund';
        $params['op']       = 'refund-partial';
        $params['transId']  = $transactionId;
        $params['amount']   = $amount;
        $params['currency'] = $payment->getOrder()->getBaseCurrencyCode();

        $responseBody = $this->processAdminRequest($params);
        $response = explode(',', $responseBody);
        if (count($response) <= 0 || $response[0] != 'A' || $response[1] != $transactionId) {
            $message = $this->_getHelper()->__('Error during refunding online. Server response: %s', $responseBody);
            $this->_debug($message);
            Mage::throwException($message);
        }
        return $this;
    }

    /**
     * Capture preatutharized amount
     * @param Varien_Object $payment
     * @param <type> $amount
     */
	public function capture(Varien_Object $payment, $amount)
	{
        if (!$this->canCapture()) {
            return $this;
        }

        if (Mage::app()->getRequest()->getParam('transId')) {
            // Capture is called from response action
            $payment->setStatus(self::STATUS_APPROVED);
            return $this;
        }
        $transactionId = $payment->getLastTransId();
        $params = $this->_prepareAdminRequestParams();
        $params['transId']  = $transactionId;
        $params['authMode'] = '0';
        $params['op']       = 'postAuth-full';

        $responseBody = $this->processAdminRequest($params);
        $response = explode(',', $responseBody);

        if (count($response) <= 0 || $response[0] != 'A' || $response[1] != $transactionId) {
            $message = $this->_getHelper()->__('Error during capture online. Server response: %s', $responseBody);
            $this->_debug($message);
            Mage::throwException($message);
        } else {
            $payment->getOrder()->addStatusToHistory($payment->getOrder()->getStatus(), $this->_getHelper()->__('Tmgco transaction has been captured.'));
        }
    }


    /**
     * Check refund availability
     *
     * @return bool
     */
    public function canRefund ()
    {
        return $this->getConfigData('enable_online_operations');
    }

    public function canRefundInvoicePartial()
    {
        return $this->getConfigData('enable_online_operations');
    }

    public function canRefundPartialPerInvoice()
    {
        return $this->canRefundInvoicePartial();
    }

    public function canCapturePartial()
    {
        if (Mage::app()->getFrontController()->getAction()->getFullActionName() != 'adminhtml_sales_order_creditmemo_new'){
            return false;
        }
        return $this->getConfigData('enable_online_operations');
    }

	protected function processAdminRequest($params, $requestTimeout = 60)
	{
		try {
			$client = new Varien_Http_Client();
			$client->setUri($this->getAdminUrl())
				->setConfig(array('timeout'=>$requestTimeout,))
				->setParameterPost($params)
				->setMethod(Zend_Http_Client::POST);

			$response = $client->request();
			$responseBody = $response->getBody();

			if (empty($responseBody))
				Mage::throwException($this->_getHelper()->__('Tmgco API failure. The request has not been processed.'));
			// create array out of response

		} catch (Exception $e) {
            $this->_debug('Tmgco API connection error: '.$e->getMessage());
			Mage::throwException($this->_getHelper()->__('Tmgco API connection error. The request has not been processed.'));
		}

		return $responseBody;
	}

    protected function _prepareAdminRequestParams()
    {
        $params = array (
            'authPW'   => $this->getConfigData('auth_password'),
            'instId'   => $this->getConfigData('admin_inst_id'),
        );
        if ($this->getConfigData('transaction_mode') == 'test') {
            $params['testMode'] = 100;
        }
        return $params;
    }

    /**
     * Log debug data to file
     *
     * Prior Magento 1.4.1 this method doesn't exists. So it is mainly to provide
     * BC.
     *
     * @param mixed $debugData
     */
    protected function _debug($debugData)
    {
        if (method_exists($this, 'getDebugFlag')) {
            return parent::_debug($debugData);
        }

        if ($this->getConfigData('debug')) {
            Mage::log($debugData, null, 'payment_' . $this->getCode() . '.log', true);
        }
    }

    private function setOrderParams($order_total = 0, $clientid="", $orderid="", $client_email="",
                                    $client_phone="", $service_name="", $form_url="", $secret_key="")
    {
       $this->setOrderTotal($order_total);
       $this->order_params = array(
           "sum" => $order_total,
           "clientid" => $clientid,
           "orderid" => $orderid,
           "client_email" => $client_email,
           "client_phone" => $client_phone,
           "phone" => $phone,
           "service_name" => $service_name,
           "form_url" => $form_url,
           "secret_key" => $secret_key,
       );
    }

    private function getOrderParams($value)
    {
        return array_key_exists($value, $this->order_params) ? $this->order_params["$value"] : False;
    }

    private function updateFiscalCart($ftype, $name="", $price=0, $quantity=0, $sum=0, $tax="none", $tax_sum=0)
    {
        //update fz54 cart
        if ($ftype === "create") {
            $name = str_replace("\n ", "", $name);
            $name = str_replace("\r ", "", $name);
            $name = str_replace(" ", "&nbsp;", $name);
            $name = preg_replace('/"{1,}/','\'',$name);
            $name = htmlspecialchars($name);
        }
        $this->fiscal_cart[] = array(
            "name" => $name,
            "price" => $price,
            "quantity" => $quantity,
            "sum" => $sum,
            "tax" => $tax,
            "tax_sum" => number_format($tax_sum, 2, ".", "")
        );
    }

    private function getFiscalCart()
    {
        return $this->fiscal_cart;
    }

    private function setDiscounts($discounts)
    {
        //set discounts
        if ($this->getOrder()->getDiscountAmount() < 0) {

            //foreach fiscal cart without shipping
            for ($pos=0; $pos<count($this->getFiscalCart()); $pos++) {
                $this->fiscal_cart[$pos]["sum"] -= $discounts[$pos];
                $this->fiscal_cart[$pos]["price"] = $this->fiscal_cart[$pos]["sum"]/$this->fiscal_cart[$pos]["quantity"];
                //formatting
                $this->fiscal_cart[$pos]["price"] = number_format($this->fiscal_cart[$pos]["price"], 3, ".", "");
                $this->fiscal_cart[$pos]["sum"] = number_format($this->fiscal_cart[$pos]["sum"], 2, ".", "");

                //recalculate taxes
                $this->recalculateTaxes($pos);
            }
        }
    }

    private function correctPrecision($cart_sum)
    {
        //handle possible precision problem
        $fiscal_cart_sum = $cart_sum;
        $total_sum = number_format($this->getOrderTotal(), 2, ".", "");
        //add shipping sum to cart sum
        if ($this->getShippingPrice() > 0)
            $fiscal_cart_sum += $this->fiscal_cart[count($this->fiscal_cart)-1]['sum'];
        //debug_info
        //echo "total: " . $total_sum . " - cart: " . $cart_sum;
        $diff_sum = $fiscal_cart_sum - $total_sum;
        if (abs($diff_sum) <= 0.01) {
            $this->setOrderTotal(number_format($total_sum+$diff_sum, 2, ".", ""));
        }
        else {
            if ($this->getUseDelivery() && ($fiscal_cart_sum < $total_sum)) {
                $this->setOrderTotal(number_format($total_sum+$diff_sum, 2, ".", ""));
                $delivery_pos = count($this->getFiscalCart())-1;
                $this->fiscal_cart[$delivery_pos]["price"] = number_format(
                                   $this->fiscal_cart[$delivery_pos]["price"]+$diff_sum, 2, ".", "");
                $this->fiscal_cart[$delivery_pos]["sum"] = number_format(
                                   $this->fiscal_cart[$delivery_pos]["sum"]+$diff_sum, 2, ".", "");
                $this->recalculateTaxes($delivery_pos);
            }
        }
    }

    private function setOrderTotal($value)
    {
        $this->order_total = $value;
    }

    private function getOrderTotal($format=False)
    {
        return ($format) ? number_format($this->order_total, 2, ".", "") :
                                         $this->order_total;
    }

    private function setShippingPrice($value)
    {
        $this->shipping_price = $value;
    }

    private function getShippingPrice()
    {
        return $this->shipping_price;
    }

    private function getPaymentFormType()
    {
        if (strpos($this->order_params["form_url"], "/order/inline") == True)
            return "order";
        else
            return "create";
    }

    private function setUseTaxes()
    {
        $this->use_taxes = True;
    }

    private function getUseTaxes()
    {
        return $this->use_taxes;
    }

    private function setUseDelivery()
    {
        $this->use_delivery = True;
    }

    private function getUseDelivery()
    {
        return $this->use_delivery;
    }

    private function recalculateTaxes($item_pos)
    {
        //recalculate taxes
        switch($this->fiscal_cart[$item_pos]['tax']) {
            case "vat10":
                $this->fiscal_cart[$item_pos]['tax_sum'] = round((float)
                    (($this->fiscal_cart[$item_pos]['sum']/110)*10), 2);
                break;
            case "vat18":
                $this->fiscal_cart[$item_pos]['tax_sum'] = round((float)
                    (($this->fiscal_cart[$item_pos]['sum']/118)*18), 2);
                break;
        }
    }
}
