<?php
class Smarty_Tmgco_ProcessingController extends Mage_Core_Controller_Front_Action
{
    protected $_successBlockType = 'tmgco/success';
    protected $_failureBlockType = 'tmgco/failure';
    protected $_cancelBlockType = 'tmgco/cancel';

    protected $_order = NULL;
    protected $_paymentInst = NULL;


    /**
     * Get singleton of Checkout Session Model
     *
     * @return Mage_Checkout_Model_Session
     */
    protected function _getCheckout()
    {
        return Mage::getSingleton('checkout/session');
    }


    //for callback post request
    public function notifyAction() {
      $ret_value = '';

      // check request type
      if (!$this->getRequest()->isPost())
        die('Wrong request type (not Post)');
     

          // get request variables
      $request = $this->getRequest()->getPost();
      if (empty($request)) {
          die('Request doesn\'t contain POST elements.');
      }

$the_Id		=  $request['id'];
$the_Sum	=  $request['sum'];
$the_Clientid	=  $request['clientid'];
$the_Orderid	=  $request['orderid'];
$the_Key	=  $request['key'];

          // check order id
      if (empty($the_Orderid) || strlen($the_Orderid) > 50)
          die('Missing or invalid order ID');

          // load order for further validation
      $this->_order = Mage::getModel('sales/order')->loadByIncrementId($the_Orderid);
      if (!$this->_order->getId())
          die('Order not found');
      $our_orderId = $this->_order->getIncrementId();

      $our_price = number_format($this->_order->getBaseGrandTotal(),2,'.','');
      if ($our_price != $the_Sum)
          die('Incorrect amount');

      $this->_paymentInst = $this->_order->getPayment()->getMethodInstance();
      $our_key = $this->_paymentInst->getConfigData('security_key');

//      $our_signature = md5($the_Id . $our_price . $our_customerId . $our_orderId . $our_key);
      $our_signature = md5($the_Id . $the_Sum . $the_Clientid . $the_Orderid . $our_key);

          // check transaction signature
      if($the_Key != $our_signature)
        die('Message digest incorrect');

      $this->_order->getPayment()->setTransactionId($the_Id)->setLastTransId($the_Id);

      if ($this->_order->canInvoice()) {
/*        $invoiceId = Mage::getModel('sales/order_invoice_api')->create($this->_order->getIncrementId(), array());
        $invoice = Mage::getModel('sales/order_invoice')->loadByIncrementId($invoiceId);
        $invoice->capture()->save(); */
      }


      $this->_order->setData('state', $this->_paymentInst->getConfigData('order_status'));
      $this->_order->setData('status', $this->_paymentInst->getConfigData('order_status'));
      $this->_order->save();

      if ($this->_order->canInvoice() && $this->_order->getTotalPaid() == 0) {
        $invoice = $this->_order->prepareInvoice();
        $invoice->register()->capture();
        Mage::getModel('core/resource_transaction')
          ->addObject($invoice)
          ->addObject($invoice->getOrder())
          ->save();
        $this->_order->save();
      }

      //sending email
      $this->_order->sendNewOrderEmail();
      $this->_order->setEmailSent(true);
      $this->_order->save();

      $our_hash = md5($the_Id . $our_key);

      die("OK $our_hash");
    }


    /**
     * when customer selects Tmgco payment method
     */
    public function redirectAction()
    {
        try {
            $session = $this->_getCheckout();

            $order = Mage::getModel('sales/order');
            $order->loadByIncrementId($session->getLastRealOrderId());
            if (!$order->getId()) {
                Mage::throwException('No order for processing found');
            }
            if ($order->getState() != Mage_Sales_Model_Order::STATE_PENDING_PAYMENT) {
                $order->setState(
                    Mage_Sales_Model_Order::STATE_PENDING_PAYMENT,
                    $this->_getPendingPaymentStatus(),
                    Mage::helper('tmgco')->__('Customer was sent to PayKeeper form')
                )->save();
            }

            if ($session->getQuoteId() && $session->getLastSuccessQuoteId()) {
                $session->setTmgcoQuoteId($session->getQuoteId());
                $session->setTmgcoSuccessQuoteId($session->getLastSuccessQuoteId());
                $session->setTmgcoRealOrderId($session->getLastRealOrderId());
                $session->getQuote()->setIsActive(false)->save();
                $session->clear();
            }

            //send email with order information
            $order->sendNewOrderEmail();
            $order->setEmailSent(true);
            $order->save();

            $this->loadLayout();
            $this->renderLayout();
            return;
        } catch (Mage_Core_Exception $e) {
            $this->_getCheckout()->addError($e->getMessage());
        } catch(Exception $e) {
            $this->_debug('Tmgco error: ' . $e->getMessage());
            Mage::logException($e);
        }
        $this->_redirect('checkout/cart');
    }

    /**
     * Tmgco returns POST variables to this action
     */
/*
    public function responseAction()
    {
        try {
            $request = $this->_checkReturnedPost();
            if ($request['transStatus'] == 'Y') {
                $this->_processSale($request);
            } elseif ($request['transStatus'] == 'C') {
                $this->_processCancel($request);
            } else {
                Mage::throwException('Transaction was not successfull.');
            }
        } catch (Mage_Core_Exception $e) {
            $this->_debug('Tmgco response error: ' . $e->getMessage());
            $this->getResponse()->setBody(
                $this->getLayout()
                    ->createBlock($this->_failureBlockType)
                    ->setOrder($this->_order)
                    ->toHtml()
            );
        }
    }
*/

    /**
     * Tmgco return action
     */
    public function successAction()
    {
        try {
            $session = $this->_getCheckout();
            $session->unsTmgcoRealOrderId();
            $session->setQuoteId($session->getTmgcoQuoteId(true));
            $session->setLastSuccessQuoteId($session->getTmgcoSuccessQuoteId(true));
            $this->_redirect('checkout/onepage/success');
            return;
        } catch (Mage_Core_Exception $e) {
            $this->_getCheckout()->addError($e->getMessage());
        } catch(Exception $e) {
            $this->_debug('Tmgco error: ' . $e->getMessage());
            Mage::logException($e);
        }
        $this->_redirect('checkout/cart');
    }

    /**
     * Tmgco return action
     */
    public function cancelAction()
    {
        // set quote to active
        $session = $this->_getCheckout();
        if ($quoteId = $session->getTmgcoQuoteId()) {
            $quote = Mage::getModel('sales/quote')->load($quoteId);
            if ($quote->getId()) {
                $quote->setIsActive(true)->save();
                $session->setQuoteId($quoteId);
            }
        }
        $session->addError(Mage::helper('tmgco')->__('The order has been canceled.'));
        $this->_redirect('checkout/cart');
    }


    /**
     * Checking POST variables.
     * Creating invoice if payment was successfull or cancel order if payment was declined
     */
    protected function _checkReturnedPost()
    {
    }

    /**
     * Process success response
     */
    protected function _processSale($request)
    {

//                $this->_order->setState($this->_paymentInst->getConfigData('order_status'));
//                break;

/*
        $this->_order->sendNewOrderEmail();
        $this->_order->setEmailSent(true);

        $this->_order->save();

        $this->getResponse()->setBody(
            $this->getLayout()
                ->createBlock($this->_successBlockType)
                ->setOrder($this->_order)
                ->toHtml()
        );
*/

    }

    /**
     * Process success response
     */
    protected function _processCancel($request)
    {
        // cancel order
        if ($this->_order->canCancel()) {
            $this->_order->cancel();
            $this->_order->addStatusToHistory(Mage_Sales_Model_Order::STATE_CANCELED, Mage::helper('tmgco')->__('Payment was canceled'));
            $this->_order->save();
        }

        $this->getResponse()->setBody(
            $this->getLayout()
                ->createBlock($this->_cancelBlockType)
                ->setOrder($this->_order)
                ->toHtml()
        );
    }

    protected function _getPendingPaymentStatus()
    {
        return Mage::helper('tmgco')->getPendingPaymentStatus();
    }

    /**
     * Log debug data to file
     *
     * @param mixed $debugData
     */
    protected function _debug($debugData)
    {
        if (Mage::getStoreConfigFlag('payment/tmgco_cc/debug')) {
            Mage::log($debugData, null, 'payment_tmgco_cc.log', true);
        }
    }
}
