<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'paygw_paykeeper', language 'ru'
 *
 * @package    paygw_paykeeper
 * @subpackage paykeeper
 * @copyright  2024 PayKeeper Support <support@paykeeper.ru>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pkserver'] = 'Хост сервера PayKeeper';
$string['pksecret'] = 'Секретное слово';
$string['pklogin'] = 'Логин от личного кабинета PayKeeper';
$string['pkpassword'] = 'Пароль от логина';

$string['abouttopay'] = 'Вы собираетесь пожертвовать на';
$string['apikey'] = 'API Key';
$string['callback_help'] = 'Скопируйте эту ссылку и вставьте в личном кабинете PayKeeper в разделе «Настройки» - «Получение информации о платежах»';
$string['callback_url'] = 'URL для уведомлений:';
$string['cost'] = 'Стоимость записи';
$string['currency'] = 'Валюта';
$string['fixdesc'] = 'Фиксированный комментарий платежа';
$string['fixdesc_help'] = 'Эта настройка устанавливает фиксированный комментарий для всех платежей, и отключает отображение описания комментария на странице платежа.';
$string['gatewaydescription'] = 'PayKeeper — платёжная платформа, позволяющая принимать оплату картами онлайн.';
$string['gatewayname'] = 'PayKeeper';
$string['internalerror'] = 'Произошла внутренняя ошибка. Пожалуйста, свяжитесь с нами.';
$string['istestmode'] = 'Тестовый режим';
$string['maxcost'] = 'Максимальная цена';
$string['password'] = 'Резервный пароль';
$string['password_error'] = 'Введён неверный платёжный пароль';
$string['password_help'] = 'С помощью этого пароля можно обойти процесс отплаты. Может быть полезен когда нет возможности произвести оплату.';
$string['password_success'] = 'Платёжный пароль принят';
$string['password_text'] = 'Если у вас нет возможности сделать пожертвование, то попросите у вашего куратора пароль и введите его.';
$string['passwordmode'] = 'Разрешить ввод резервного пароля';
$string['payment'] = 'Пожертвование';
$string['payment_error'] = 'Ошибка оплаты';
$string['payment_success'] = 'Оплата успешно произведена';
$string['paymentserver'] = 'URL сервера оплаты';
$string['paymore'] = 'Если вы хотите пожертвовать больше, то просто впишите свою сумму вместо указанной.';
$string['pluginname'] = 'Платежи PayKeeper';
$string['pluginname_desc'] = 'Плагин PayKeeper позволяет получать платежи через различные способы оплат и банки.';
$string['sendpaymentbutton'] = 'Пожертвовать!';
$string['shopid'] = 'Идентификатор магазина';
$string['showduration'] = 'Показывать длительность обучения на странице';
$string['skipmode'] = 'Показать кнопку обхода платежа';
$string['skipmode_help'] = 'Эта настройка разрешает кнопку обхода платежа, может быть полезна в публичных курсах с необязательной оплатой.';
$string['skipmode_text'] = 'Если вы не имеете возможности совершить пожертвование через платёжную систему, то можете нажать на кнопку внизу.';
$string['skippaymentbutton'] = 'Не имею';
$string['suggest'] = 'Рекомендуемая цена';
$string['usedetails'] = 'Показывать свёрнутым';
$string['usedetails_help'] = 'Прячет кнопку или пароль под сворачиваемый блок, если они включены.';
$string['usedetails_text'] = 'Нажмите тут если у вас нет возможности совершить пожертвование';
$string['vatcode'] = 'Ставка НДС';
$string['vatcode_help'] = 'Ставка НДС согласно API документации PayKeeper.';

$string['privacy:metadata'] = 'The PayKeeper plugin store some personal data.';
$string['privacy:metadata:paygw_paykeeper:paygw_paykeeper'] = 'Store some data';
$string['privacy:metadata:paygw_paykeeper:pkserver'] = 'PayKeeper server host';
$string['privacy:metadata:paygw_paykeeper:pksecret'] = 'Secret word';
$string['privacy:metadata:paygw_paykeeper:pklogin'] = 'Login from PayKeeper personal account';
$string['privacy:metadata:paygw_paykeeper:pkpassword'] = 'Password for login';
$string['privacy:metadata:paygw_paykeeper:paykeeper_plus'] = 'Send json data';
$string['privacy:metadata:paygw_paykeeper:invoiceid'] = 'Invoice id';
$string['privacy:metadata:paygw_paykeeper:courseid'] = 'Course id';
$string['privacy:metadata:paygw_paykeeper:groupnames'] = 'Group names';
$string['privacy:metadata:paygw_paykeeper:success'] = 'Status';

$string['messagesubject'] = 'Уведомление о платеже ({$a})';

$string['message_success_completed'] = 'Здравствуйте, {$a->firstname}!
Платёжная транзакция № {$a->orderid} на {$a->localizedcost} успешно завершена. Спасибо за ваше пожертвование.
Если элемент курса недоступен, обратитесь в техподдержку сайта.';

$string['message_success_recurrent'] = 'Здравствуйте, {$a->firstname}!
Регулярный платёж № {$a->orderid} на {$a->localizedcost} успешно создан и оплачен. Спасибо за ваше пожертвование.
Следующий автоматический платёж назначен на {$a->nextpay}.
Отключить регулярные платежи можно в разделе Отчёты (оплата) в личном профиле {$a->url}/user/profile.php';

$string['message_recurrent_created'] = 'Здравствуйте, {$a->firstname}!
Регулярный платёж № {$a->orderid} на {$a->localizedcost} создан и передан в банк.
Отключить регулярные платежи можно в разделе Отчёты (оплата) в личном профиле {$a->url}/user/profile.php';

$string['message_recurrent_error'] = 'Здравствуйте, {$a->firstname}!
Регулярный платёж № {$a->orderid} на {$a->localizedcost} завершился с ошибкой.
Подписка будет отключена, для возобновления подписки произведите новую оплату.';

$string['message_recurrent_notify'] = 'Здравствуйте, {$a->firstname}!
Напоминаем о том, что приближается дата регулярного платежа № {$a->orderid} на {$a->localizedcost}.
Пожалуйста, обеспечьте наличие указанной суммы на счёте {$a->nextpay}, иначе подписка не будет продлена.
Отключить регулярные платежи можно в разделе Отчёты (оплата) в личном профиле {$a->url}/user/profile.php';

$string['message_invoice_created'] = 'Здравствуйте, {$a->firstname}!
Платёжная ссылка {$a->orderid} на {$a->localizedcost} успешно создана.
Вы можете совершить платёж по ней в течении часа.';

$string['messageprovider:payment_receipt'] = 'Чек об оплате';

$string['fixcost'] = 'Режим фиксированной цены';
$string['fixcost_help'] = 'Отключает для студентов возможность оплаты произвольной суммой.';
$string['maxcosterror'] = 'Максимальная цена должна быть выше рекомендуемой цены';

$string['recurrent'] = 'Включить регулярные платежи';
$string['recurrent_help'] = 'Регулярные (рекуррентные) платежи исполняются по таймеру без участия студента, данные первого платежа сохраняются на стороне банка и используются повторно, с некоторой периодичностью.';
$string['recurrentperiod'] = 'Периодичность регулярного платежа';
$string['recurrentperiod_help'] = 'Желательно указать периодичность не чаще чем раз в день. Это связано с выполеннием соответствующей регулярной задачи в планировщике задач. Чаще чем раз в день - только для тестов.';
$string['recurrentperioderror'] = 'Укажите периодичность';
$string['recurrentday'] = 'День ежемесячного платежа';
$string['recurrentday_help'] = 'Указывает день месяца в который будут происходить очередные списания. Если не установлено, то платежи будут производится по цикличному расписанию';
$string['recurrentdesc'] = 'Этот платёж будет регулярным! Cумма и дата следующего платежа может измениться.<br>
Отключить регулярные платежи вы можете в своём Профиле в разделе Отчёты "Оплата и регулярные подписки".';

$string['recurrentcost'] = 'Стоимость регулярного платежа';
$string['recurrentcost_help'] = 'Указывает какую цену брать при проведении регулярного платежа:<br>
Уплаченная - та, что была указана пользователем при создании регулярного платежа.<br>
Стоимость элемента - та, которая указана в настройках платёжного модуля или курса.<br>
Рекомендуемая - берётся из настроек этого интерфейса.';
$string['recurrentcost1'] = 'Уплаченная';
$string['recurrentcost2'] = 'Стоимость элемента';
$string['recurrentcost3'] = 'Рекомендуемая цена';
$string['suggesterror'] = 'Рекомендуемая цена должна быть указана для включенного регулярного платежа';

$string['sendlinkmsg'] = 'Отправлять ссылку оплаты на почту';
$string['sendlinkmsg_help'] = 'Если включено, то ссылка на счёт для оплаты будет отправляться на почту пользователя.';

$string['noreportplugin'] = '<font color=red>Не установлен report_payments плагин, вы не сможете отменить регулярные платежи.</font>';

$string['donate'] = '<div>Версия плагина: {$a->release} ({$a->versiondisk})<br>
Новые версии плагина вы можете найти на <a href=https://docs.paykeeper.ru/cms>docs.paykeeper.ru</a>
</div>';

$string['error_txdatabase'] = 'Error write TX data to database';
$string['error_notvalidtxid'] = 'ERROR. Not a valid transaction id';
$string['error_notvalidpayment'] = 'ERROR. Not a valid payment';
