<?php

use \Joomla\CMS\Factory;

if (!defined('_VALID_MOS') && !defined('_JEXEC')) {
    die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');
}
if (!class_exists('vmPSPlugin')) {
    require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');
}

include_once('paykeeper_common.php');

class plgVMPaymentPaykeeper extends vmPSPlugin
{
    public static $_this = false;
    public static $flag = false;

    function __construct(& $subject, $config)
    {
        parent::__construct($subject, $config);
        $this->_loggable = true;
        $this->tableFields = array_keys($this->getTableSQLFields());
        $this->_tablepkey = 'id';
        $this->_tableId = 'id';
        $varsToPush = $this->getVarsToPush();
        $this->setConfigParameterable($this->_configTableFieldName, $varsToPush);
    }

    protected function getVmPluginCreateTableSQL()
    {
        return $this->createTableSQL('Payment RobokassaPro Table');
    }

    function getTableSQLFields()
    {
        $SQLfields = array(
            'id' 							=> 'int(1) UNSIGNED NOT NULL AUTO_INCREMENT',
            'virtuemart_order_id' 			=> 'int(1) UNSIGNED',
            'order_number'              	=> 'char(64)',
            'virtuemart_paymentmethod_id' 	=> 'mediumint(1) UNSIGNED',
            'payment_name' 					=> 'char(255) NOT NULL DEFAULT \'\' ',
            'payment_order_total'       	=> 'decimal(15,5) NOT NULL DEFAULT \'0.00000\' ',
            'payment_currency' 				=> 'char(3) ',
            'cost_per_transaction' 			=> 'decimal(10,2)',
            'cost_percent_total' 			=> 'char(10)',
            'tax_id' 						=> 'smallint(1)'
        );

        return $SQLfields;
    }

    function plgVmConfirmedOrder($cart, $order)
    {
        $order_details = $order['details']['BT'];
        if (!($method = $this->getVmPluginMethod($order_details->virtuemart_paymentmethod_id))) {
            return null;
        }

        if (!$this->selectedThisElement($method->payment_element)) {
            return false;
        }
        $session = Factory::getApplication()->getSession();
        $return_context = $session->getId();

        if (!class_exists('VirtueMartModelOrders')) {
            require( JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php' );
        }
        if (!class_exists('VirtueMartModelCurrency')) {
            require( JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'currency.php' );
        }
        $new_status = $method->status_pending;
        $this->getPaymentCurrency($method);
        $q = 'SELECT `currency_code_3` FROM `#__virtuemart_currencies` WHERE `virtuemart_currency_id`="' . $method->payment_currency . '" ';
        $db = Factory::getDbo();
        $db->setQuery($q);
        $currency_code_3 = $db->loadResult();
        $paymentCurrency = CurrencyDisplay::getInstance($method->payment_currency);
        $totalInPaymentCurrency = round($paymentCurrency->convertCurrencyTo($method->payment_currency, $order_details->order_total, false), 2);
        $dbValues = array();
        $this->_virtuemart_paymentmethod_id      = $order_details->virtuemart_paymentmethod_id;
        $dbValues['payment_name']                = $this->renderPluginName($method);
        $dbValues['order_number']                = $order_details->order_number;
        $dbValues['virtuemart_paymentmethod_id'] = $this->_virtuemart_paymentmethod_id;
        $dbValues['payment_currency']            = $currency_code_3 ;
        $dbValues['payment_order_total']         = $totalInPaymentCurrency;
        $this->storePSPluginInternalData($dbValues);

        $form = "";

        $status_pending = 0;
        if (isset($method->status_pending)) $status_pending=$method->status_pending;
        if ($status_pending) {
            $modelOrder = VmModel::getModel ('orders');
            $order['order_status'] = $new_status;
            $order['customer_notified'] = 1;
            $order['comments'] = '';
            $modelOrder->updateStatusForOneOrder($order_details->virtuemart_order_id, $order, true);
        } else {
            $this->processConfirmedOrderPaymentResponse(true, $cart, $order, $form, $this->renderPluginName($method, $order), 'P');
        }
        $form = $this->getPaymentForm($order, $method);
        echo $form;
    }

    //Отображение информации о заказе в админке
    function plgVmOnShowOrderBEPayment($virtuemart_order_id, $virtuemart_payment_id)
    {

        if (!$this->selectedThisByMethodId($virtuemart_payment_id))
        {
            return null;
        }
        $db = Factory::getDbo();
        $q = 'SELECT * FROM `' . $this->_tablename . '` '
            . 'WHERE `virtuemart_order_id` = ' . $virtuemart_order_id;
        $db->setQuery($q);
        if (!($paymentTable = $db->loadObject()))
        {
            vmWarn(500, $q . " " . $db->getErrorMsg());
            return '';
        }
        $this->getPaymentCurrency($paymentTable);

        $html = '<table class="adminlist table">' . "\n";
        $html .=$this->getHtmlHeaderBE();
        $html .= $this->getHtmlRowBE('VMPAYMENT_PAYKEEPER', $paymentTable->payment_name);
        $html .= '</table>' . "\n";
        return $html;
    }

    function getCosts (VirtueMartCart $cart, $method, $cart_prices) {

    }

    protected function checkConditions($cart, $method, $cart_prices)
    {
        return true;
    }

    //Переход после завершения оплаты
    function plgVmOnPaymentResponseReceived(  &$html)
    {

        if(self::$flag) return null;
        if(!(int)Factory::getApplication()->input->get('paykeeper',0)) {
            return NULL;
        }
        if (!class_exists('VirtueMartModelOrders'))
        {
            require( JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php' );
        }
        $html = "Оплата прошла успешно";
        if (!class_exists('VirtueMartCart'))
        {
            require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
        }
        $cart = VirtueMartCart::getCart();
        $cart->emptyCart();
        self::$flag = true; // а это, чтобы несколько раз одно и то же не делать
        return true;
    }

    function plgVmOnUserPaymentCancel()
    {
        return null;
    }

    function plgVmOnPaymentNotification()
    {

        if(!(int)Factory::getApplication()->input->get('paykeeper',0)) {
            return NULL;
        }
        //Изменение статуса заказа на Confirmed после оплаты счета
        if (!class_exists('VirtueMartModelOrders'))
        {
            require( JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php' );
        }
        $pay_data   =   Factory::getApplication()->input;
        $id         =   $pay_data->get('id');
        $orderid    =   $pay_data->get('orderid');
        $sum        =   $pay_data->get('sum');
        $key        =   $pay_data->get('key');
        $clientid   =   $_POST['clientid'];// так, потому что Factory::getApplication()->input убирает все пробелы из имени и фамилии
        if(!isset($orderid,$id,$orderid,$key,$sum,$clientid))
        {
            return "Not enough actual parameters!";
        }
        $payment = $this->getDataByOrderId($orderid);
        $method = $this->getVmPluginMethod($payment->virtuemart_paymentmethod_id);

        $this->getPaymentCurrency($method);
        if (!class_exists('CurrencyDisplay'))
            require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'currencydisplay.php');
        $paymentCurrency        = CurrencyDisplay::getInstance($method->payment_currency);
        $order_model  = new VirtueMartModelOrders();
        $order_info   = $order_model->getOrder($orderid);
        $totalInPaymentCurrency = round($paymentCurrency->convertCurrencyTo($method->payment_currency, $order_info['details']['BT']->order_total, false), 2);
        $secret_word = $method->secret_key;
        $concat = $id.number_format($sum, 2, ".", "" ).$clientid.$orderid.$secret_word;
        $sig = md5($concat);
        if ($sig != $key) {
            echo 'Error! Hash mismatch';
            jexit();
        }
        if ($sum != $totalInPaymentCurrency) {
            echo 'Error order sum!';
            jexit();
        }
        $new_status = $method->status_success;
        $modelOrder = VmModel::getModel('orders');

        if($order_info['details']['BT']->order_status!=$new_status) {

            $order = array();
            $order['order_status'] = $new_status;
            $order['customer_notified'] =1;
            $order['comments']='PayKeeper';
            $modelOrder->updateStatusForOneOrder($orderid, $order, true);
        }
        echo 'OK ' . md5($pay_data->get('id').$secret_word);
        jexit();

        return true;
    }

    function plgVmOnStoreInstallPaymentPluginTable($jplugin_id)
    {
        return $this->onStoreInstallPluginTable($jplugin_id);
    }

    public function plgVmOnSelectCheckPayment(VirtueMartCart $cart)
    {
        return $this->OnSelectCheck($cart);
    }

    public function plgVmDisplayListFEPayment(VirtueMartCart $cart, $selected, &$htmlIn) {
        $this->cart = $cart;
        return $this->displayListFE($cart, $selected, $htmlIn);
    }

    public function getPluginHtml($plugin, $selectedPlugin, $pluginSalesPrice){

        if(isset($this->cart->products) && count($this->cart->products) <= 0) return;
        $pluginmethod_id = $this->_idName;
        $pluginName = $this->_psType . '_name';
        if ($selectedPlugin == $plugin->$pluginmethod_id) {
            $checked = 'checked="checked"';
        } else {
            $checked = '';
        }

        if (!class_exists ('CurrencyDisplay')) {
            require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'currencydisplay.php');
        }
        $currency = CurrencyDisplay::getInstance ();
        $costDisplay = "";
        if ($pluginSalesPrice) {
            $costDisplay = $currency->priceDisplay ($pluginSalesPrice);
            $costDisplay = '<span class="' . $this->_type . '_cost"> (' . JText::_ ('COM_VIRTUEMART_PLUGIN_COST_DISPLAY') . $costDisplay . ")</span>";
        }
        $s = '';

        $html = '<input type="radio" name="' . $pluginmethod_id . '" id="' . $this->_psType . '_id_' . $plugin->$pluginmethod_id . '"   value="' . $plugin->$pluginmethod_id . '" ' . $checked . ">\n"
            . '<label for="' . $this->_psType . '_id_' . $plugin->$pluginmethod_id . '">' . '<span class="' . $this->_type . '">' . $plugin->$pluginName . $costDisplay . $s. "</span></label>\n";

        return $html;
    }

    public function plgVmonSelectedCalculatePricePayment(VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name)
    {
        return $this->onSelectedCalculatePrice($cart, $cart_prices, $cart_prices_name);
    }

    function plgVmgetPaymentCurrency($virtuemart_paymentmethod_id, &$paymentCurrencyId)
    {

        if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id)))
        {
            return null;
        }
        if (!$this->selectedThisElement($method->payment_element))
        {
            return false;
        }
        $this->getPaymentCurrency($method);

        $paymentCurrencyId = $method->payment_currency;
    }

    function logingActions($params)
    {
        jimport('joomla.error.log');
        $options = array(
            'format' => "{DATE}\t{TIME}\t{ORDER}\t{ACTION}"
        );
        $log = &JLog::getInstance('paykeeper_events.log.php', $options);
        $log->addEntry(array('ORDER' => $params['ORDER'],'ACTION' => $params['ACTION']));
    }

    function plgVmOnCheckAutomaticSelectedPayment(VirtueMartCart $cart, array $cart_prices = array())
    {
        return $this->onCheckAutomaticSelected($cart, $cart_prices);
    }

    public function plgVmOnShowOrderFEPayment($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name)
    {

    }

    function plgVmonShowOrderPrintPayment($order_number, $method_id)
    {
        return $this->onShowOrderPrint($order_number, $method_id);
    }

    function plgVmDeclarePluginParamsPayment($name, $id, &$data)
    {
        return $this->declarePluginParams('payment', $name, $id, $data);
    }

    function plgVmSetOnTablePluginParamsPayment($name, $id, &$table)
    {
        return $this->setOnTablePluginParams($name, $id, $table);
    }
    function plgVmDeclarePluginParamsPaymentVM3( &$data) {
        return $this->declarePluginParams('payment', $data);
    }

    function getPaymentForm($order, $method)
    {
        $paykeeper_common = new PaykeeperCommon();
        $order_details = $order['details']['BT'];

        //set order parameters
        $paykeeper_common->setOrderParams(
            $order_details->order_total,            // sum
            trim($order_details->first_name . " " . $order_details->last_name),  // clientid
            $order_details->virtuemart_order_id,    // orderid
            $order_details->email,                  // client_email
            $order_details->phone_1,                // client_phone
            "",                         // service_name
            $method->server,                        // payment form url
            $method->secret_key                     // secret key
        );

        //GENERATE FZ54 CART
        $last_index = 0;
        foreach ($order['items'] as $order_item) {
            $taxes = array("tax" => "none", "tax_sum" => 0);
            if ((float) $order_item->product_final_price <= 0) {
                continue;
            }
            $name = $order_item->order_item_name;
            $qty = (float) $order_item->product_quantity;
            $price = (float) $order_item->product_final_price;
            if ($qty == 1 && $paykeeper_common->single_item_index < 0) {
                $paykeeper_common->single_item_index = $last_index;
            }
            if ($qty > 1 && $paykeeper_common->more_then_one_item_index < 0) {
                $paykeeper_common->more_then_one_item_index = $last_index;
            }
            $tax_rate = ($order_item->product_tax/$order_item->product_item_price)*100;
            $taxes = $paykeeper_common->setTaxes($tax_rate);
            $paykeeper_common->updateFiscalCart(
                $paykeeper_common->getPaymentFormType(),
                $name,
                $price,
                $qty,
                0,
                $taxes["tax"]
            );
            $last_index++;
        }

        //add shipping parameters to cart
        $shipping_tax_rate = 0;
        $shipping_taxes = array("tax" => "none", "tax_sum" => 0);

        $shipping_price = $order_details->order_shipment;
        $shipping_tax_rate = $order_details->order_shipment_tax;

        $shipping_tax_rate_percent =
            ($order_details->order_shipment_tax > 0 && $order_details->order_shipment > 0)
                ? ($order_details->order_shipment_tax / $order_details->order_shipment) * 100
                : 0;
        $shipping_price += $shipping_tax_rate;
        $paykeeper_common->setShippingPrice($shipping_price);
        $shipment_id = $order_details->virtuemart_shipmentmethod_id;
        $shipping_name = VmModel::getModel('Shipmentmethod')->getShipment($shipment_id)->shipment_name;
        //check if delivery already in cart
        if (!$paykeeper_common->checkDeliveryIncluded($paykeeper_common->getShippingPrice(), $shipping_name)
            && $paykeeper_common->getShippingPrice() > 0)
        {
            $shipping_taxes = $paykeeper_common->setTaxes($shipping_tax_rate_percent);
            $paykeeper_common->setUseDelivery(); //for precision correct check
            $paykeeper_common->updateFiscalCart(
                $paykeeper_common->getPaymentFormType(),
                $shipping_name,
                $paykeeper_common->getShippingPrice(),
                1,
                0,
                $shipping_taxes["tax"]
            );
            $paykeeper_common->delivery_index = $last_index;
            $paykeeper_common->fiscal_cart[$last_index]['item_type'] = 'service';
        }
        $force_discounts_check = $method->force_discounts_check;

        //set discounts
        $paykeeper_common->setDiscounts($order_details->coupon_code != NULL || $force_discounts_check == 1);

        //handle possible precision problem
        $paykeeper_common->correctPrecision();

        $fiscal_cart_encoded = json_encode($paykeeper_common->getFiscalCart());

        //generate payment form
        $form = "";

        if ($paykeeper_common->getPaymentFormType() == "create") { //create form
            $to_hash = number_format($paykeeper_common->getOrderTotal(), 2, '.', '') .
                $paykeeper_common->getOrderParams("clientid")     .
                $paykeeper_common->getOrderParams("orderid")      .
                $paykeeper_common->getOrderParams("service_name") .
                $paykeeper_common->getOrderParams("client_email") .
                $paykeeper_common->getOrderParams("client_phone") .
                $paykeeper_common->getOrderParams("secret_key");
            $sign = hash ('sha256' , $to_hash);
            $form = '<h3>Сейчас вы будете перенаправлены на страницу оплаты...</h3><form name="payment" id="pay_form" action="'.$paykeeper_common->getOrderParams("form_url").'" accept-charset="utf-8" method="post">
                <input type="hidden" name="sum" value = "'.number_format($paykeeper_common->getOrderTotal(), 2, '.', '').'"/>
                <input type="hidden" name="orderid" value = "'.$paykeeper_common->getOrderParams("orderid").'"/>
                <input type="hidden" name="clientid" value = "'.$paykeeper_common->getOrderParams("clientid").'"/>
                <input type="hidden" name="client_email" value = "'.$paykeeper_common->getOrderParams("client_email").'"/>
                <input type="hidden" name="client_phone" value = "'.$paykeeper_common->getOrderParams("client_phone").'"/>
                <input type="hidden" name="service_name" value = "'.$paykeeper_common->getOrderParams("service_name").'"/>
                <input type="hidden" name="cart" value = \''.htmlentities($fiscal_cart_encoded,ENT_QUOTES).'\' />
                <input type="hidden" name="sign" value = "'.$sign.'"/>
                <input type="submit" class="btn btn-default" value="Оплатить"/>
                </form>
                <script type="text/javascript">
                window.onload=function(){
                   document.querySelector("#pay_form").submit();
                }

                </script>';
        }
        else { //order form

            $payment_parameters = array(
                "clientid"=>$paykeeper_common->getOrderParams("clientid"),
                "orderid"=>$paykeeper_common->getOrderParams('orderid'),
                "sum"=>$paykeeper_common->getOrderTotal(),
                "phone"=>$paykeeper_common->getOrderParams("phone"),
                "client_email"=>$paykeeper_common->getOrderParams("client_email"),
                "cart"=>$fiscal_cart_encoded);

            $query = http_build_query($payment_parameters);
            $query_options = array("http"=>array(
                "method"=>"POST",
                "header"=>"Content-type: application/x-www-form-urlencoded",
                "content"=>$query
            ));
            $context = stream_context_create($query_options);
            $err_num = $err_text = NULL;
            if( function_exists( "curl_init" )) { //using curl
                $CR = curl_init();
                curl_setopt($CR, CURLOPT_URL, $paykeeper_common->getOrderParams("form_url"));
                curl_setopt($CR, CURLOPT_POST, 1);
                curl_setopt($CR, CURLOPT_FAILONERROR, true);
                curl_setopt($CR, CURLOPT_POSTFIELDS, $query);
                curl_setopt($CR, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($CR, CURLOPT_SSL_VERIFYPEER, 0);
                $result = curl_exec( $CR );
                $error = curl_error( $CR );
                if( !empty( $error )) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR:".$error."</span>";
                    return false;
                }
                else {
                    $form = $result;
                }
                curl_close($CR);
            }
            else { //using file_get_contents
                if (!ini_get('allow_url_fopen')) {
                    $form_html = "<br/><span class=message>"."INTERNAL ERROR: Option allow_url_fopen is not set in php.ini"."</span>";
                }
                else {
                    $form = file_get_contents($paykeeper_common->getOrderParams("form_url"), false, $context);
                }
            }
        }
        if ($form  == "") {
            $form = '<h3>Произошла ошибка при инциализации платежа</h3><p>$err_num: '.htmlspecialchars($err_text).'</p>';
        }

        return $form;

    }

    function getPaymentMethod($order)
    {
        if (!($method = $this->getVmPluginMethod($order['details']['BT']->virtuemart_paymentmethod_id)))
        {
            return null;
        }
        return $method;
    }

}

