<?php

/**
 * @package     EasyStore.Site
 * @subpackage  EasyStore.Sample
 *
 * @copyright   Copyright (C) 2023 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Plugin\EasyStore\PayKeeper\Utils;

use Joomla\Registry\Registry;
use JoomShaper\Component\EasyStore\Administrator\Plugin\Constants;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Class that contains constants for the Paddle payment gateway.
 * @since 1.0.0
 */
class PayKeeperConstants extends Constants
{
    /**
     * Plugin parameters
     *
     * @var Registry
     *
     * @since 1.0.0
     */
    protected $params;

    /**
     * The payment plugin name
     *
     * @var string
     *
     * @since 1.0.0
     */
    protected $name = 'paykeeper';

    /**
     * The constructor method.
     *
     * @since 1.0.0
     */
    public function __construct()
    {
        /* By passing the plugin name as a parameter to the parent constructor, both plugin information and parameters will be retrieved . */

        parent::__construct($this->name);
    }

    /**
     * Get URL
     *
     * @return string
     *
     * @since 1.0.0
     */
    public function getUrl()
    {
        return $this->params->get('pk_url', '');
    }

    /**
     * Get Secret Word
     *
     * @return mixed
     *
     * @since 1.0.0
     */
    public function getSecret()
    {
        return $this->params->get('pk_secret', '');
    }

    /**
     * Get Login LK
     *
     * @return mixed
     *
     * @since 1.0.0
     */
    public function getLogin()
    {
        return $this->params->get('pk_login', '');
    }

    /**
     * Get Password LK
     *
     * @return mixed
     *
     * @since 1.0.0
     */
    public function getPass()
    {
        return $this->params->get('pk_pass', '');
    }

    /**
     * Get VAT For Goods
     *
     * @return mixed
     *
     * @since 1.0.0
     */
    public function getGoodsVat()
    {
        return $this->params->get('pk_goods_vat', '');
    }

    /**
     * Get VAT For Service
     *
     * @return mixed
     *
     * @since 1.0.0
     */
    public function getServiceVat()
    {
        return $this->params->get('pk_service_vat', '');
    }

    /**
     * Get Discount
     *
     * @return mixed
     *
     * @since 1.0.0
     */
    public function getDiscount()
    {
        return $this->params->get('pk_discount', '');
    }

    /**
     * Check Use Discount
     *
     * @return bool
     *
     * @since 1.0.0
     */
    public function useDiscount()
    {
        return $this->getDiscount() === 'yes';
    }
}