<?php namespace Paykeeper\PkPayShopaholic;

use Event;
use System\Classes\PluginBase;
use Paykeeper\PkPayShopaholic\Classes\Event\PaymentMethodModelHandler;
use Paykeeper\PkPayShopaholic\Classes\Event\ExtendPaymentMethodFieldsHandler;

/**
 * WayForPayShopaholic Plugin Information File
 */
class Plugin extends PluginBase
{
    public $require = [
        'Lovata.Toolbox',
        'Lovata.Shopaholic',
        'Lovata.OrdersShopaholic',
    ];

    /**
     * Returns information about this plugin.
     *
     * @return array
     */
    public function pluginDetails()
    {
        return [
            'name'        => 'paykeeper.pkpayshopaholic::lang.plugin.name',
            'description' => 'paykeeper.pkpayshopaholic::lang.plugin.description',
            'author'      => 'PayKeeper',
            'icon'        => 'icon-credit-card',
            'homepage'    => 'https://paykeeper.ru/'
        ];
    }

    /**
     * Boot plugin method
     */
    public function boot()
    {
        $this->addListeners();
    }

    private function addListeners()
    {
        Event::subscribe(ExtendPaymentMethodFieldsHandler::class);
        Event::subscribe(PaymentMethodModelHandler::class);
    }
}
