<?php namespace Paykeeper\PkPayShopaholic\Classes\Event;

use Config;

use Lovata\Toolbox\Classes\Event\AbstractBackendFieldHandler;

use Lovata\OrdersShopaholic\Models\PaymentMethod;
use Lovata\OrdersShopaholic\Controllers\PaymentMethods;
use Paykeeper\PkPayShopaholic\Classes\Helper\PaymentGateway;

/**
 * Class ExtendPaymentMethodFieldsHandler
 * @package Paykeeper\PkPayShopaholic\Classes\Event
 * @author PayKeeper
 */
class ExtendPaymentMethodFieldsHandler extends AbstractBackendFieldHandler
{
    /**
     * Extend backend fields
     * @param \Backend\Widgets\Form $obWidget
     */
    protected function extendFields($obWidget)
    {

        if ($obWidget->model->gateway_id != PaymentGateway::CODE) {
            return;
        }

        $obWidget->addTabFields([
            'setting_section' => [
                'label'   => 'paykeeper.pkpayshopaholic::lang.field.setting_section',
                'comment' => 'paykeeper.pkpayshopaholic::lang.comment.setting_section',
                'tab'     => 'lovata.ordersshopaholic::lang.tab.gateway',
                'type'    => 'section',
                'span'    => 'full'
            ],
            'gateway_property[payment_url]' => [
                'label'       => 'paykeeper.pkpayshopaholic::lang.field.payment_url',
                'comment'     => 'paykeeper.pkpayshopaholic::lang.comment.payment_url',
                'placeholder' => 'paykeeper.pkpayshopaholic::lang.placeholder.payment_url',
                'tab'         => 'lovata.ordersshopaholic::lang.tab.gateway',
                'required'    => 'true',
                'span'        => 'left'
            ],
            'gateway_property[secret_key]' => [
                'label'       => 'paykeeper.pkpayshopaholic::lang.field.secret_key',
                'comment'     => 'paykeeper.pkpayshopaholic::lang.comment.secret_key',
                'placeholder' => 'paykeeper.pkpayshopaholic::lang.placeholder.secret_key',
                'tab'         => 'lovata.ordersshopaholic::lang.tab.gateway',
                'required'    => 'true',
                'span'        => 'left'
            ]
        ]);
    }

    /**
     * Get model class name
     * @return string
     */
    protected function getModelClass(): string
    {
        return PaymentMethod::class;
    }

    /**
     * Get controller class name
     * @return string
     */
    protected function getControllerClass(): string
    {
        return PaymentMethods::class;
    }
}
