<?php

if (!defined('_VALID_MOS') && !defined('_JEXEC'))
    die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

if (!class_exists('vmPSPlugin')) require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');

// На сайте paykeeper указывать:
// В разделе Настройки/Получение информации о платежах:
// Способ получения уведомления о платежах: POST-оповещения
// URL, на который будут отправляться POST-запросы: http://www.вашсайт.ru/index.php?option=com_virtuemart&view=pluginresponse&task=pluginnotification&paykeeper=1&tmpl=component

// В разделе Настройки/Адреса перенаправления клиента:
// URL страницы, на которую клиент переходит при успешном завершении оплаты: http://www.вашсайт.ru/index.php?option=com_virtuemart&view=pluginresponse&task=pluginresponsereceived&paykeeper=1
// URL страницы, на которую клиент переходит при неудаче в процессе оплаты: http://www.вашсайт.ru/
// Секретное слово: любой набор латинских букв, цифр и знаков препинания. Секретное слово нужно указать на сайте paykeeper и в настройках плагина.

include_once('paykeeper.class.php');

class plgVMPaymentSttPaykeeper extends vmPSPlugin
{
	public static $_this = false;
	public static $flag = false;

	function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$this->_loggable = true;
		$this->tableFields = array_keys($this->getTableSQLFields());
		$this->_tablepkey = 'id'; 
		$this->_tableId = 'id'; 
		$varsToPush = $this->getVarsToPush();
		$this->setConfigParameterable($this->_configTableFieldName, $varsToPush);
	}

    protected function getVmPluginCreateTableSQL()
    {
		return $this->createTableSQL('Payment RobokassaPro Table');
    }

    function getTableSQLFields()
    {
		$SQLfields = array(
			'id' 							=> 'int UNSIGNED NOT NULL AUTO_INCREMENT',
			'virtuemart_order_id' 			=> 'int UNSIGNED',
			'order_number'              	=> 'char(64)',
			'virtuemart_paymentmethod_id' 	=> 'mediumint UNSIGNED',
			'payment_name' 					=> 'char(255) NOT NULL DEFAULT \'\' ',
			'payment_order_total'       	=> 'decimal(15,5) NOT NULL DEFAULT \'0.00000\' ',
			'payment_currency' 				=> 'char(3) ',
			'cost_per_transaction' 			=> 'decimal(10,2)',
			'cost_percent_total' 			=> 'char(10)',
			'tax_id' 						=> 'smallint'
		);

		return $SQLfields;
    }
    
    function plgVmConfirmedOrder($cart, $order) 
    {
		if (!($method = $this->getVmPluginMethod($order['details']['BT']->virtuemart_paymentmethod_id)))
		{
	    	return null;
		}
		if (!$this->selectedThisElement($method->payment_element))
		{
	    	return false;
		}

		$session = JFactory::getSession();
		$return_context = $session->getId();
// $this->logInfo('plgVmConfirmedOrder order number: ' . $order['details']['BT']->order_number, 'message', true);
		if (!class_exists('VirtueMartModelOrders'))
		{
	    	require( JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php' );
		}
	    if (!class_exists('VirtueMartModelCurrency'))
	    {
	    	require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'currency.php');
	    }	    
		$new_status = $method->status_pending;		    	
		$this->getPaymentCurrency($method);
		$q = 'SELECT `currency_code_3` FROM `#__virtuemart_currencies` WHERE `virtuemart_currency_id`="' . $method->payment_currency . '" ';
		$db = &JFactory::getDBO();
		$db->setQuery($q);
		$currency_code_3 = $db->loadResult();
		$paymentCurrency = CurrencyDisplay::getInstance($method->payment_currency);
		$totalInPaymentCurrency = round($paymentCurrency->convertCurrencyTo($method->payment_currency, $order['details']['BT']->order_total,false), 2);

		$dbValues = array();
		$this->_virtuemart_paymentmethod_id      = $order['details']['BT']->virtuemart_paymentmethod_id;
		$dbValues['payment_name']                = $this->renderPluginName($method);
		$dbValues['order_number']                = $order['details']['BT']->order_number;
		$dbValues['virtuemart_paymentmethod_id'] = $this->_virtuemart_paymentmethod_id;
		$dbValues['cost_per_transaction']        = $method->cost_per_transaction;
		$dbValues['cost_percent_total']          = $method->cost_percent_total;
		$dbValues['payment_currency']            = $currency_code_3 ;
		$dbValues['payment_order_total']         = $totalInPaymentCurrency;
		$dbValues['tax_id']                      = $method->tax_id;
		$this->storePSPluginInternalData($dbValues);

        $form = "";
        if ($order['details']['BT']->order_status == $method->status_pending) {
            $form = $this->getPaymentForm($order, $method);
        }

		$send_pending = 0;
		if(isset($method->send_pending)) $send_pending=$method->send_pending;
		
		if($send_pending) {
			$modelOrder = VmModel::getModel ('orders');
			$order['order_status'] = $new_status;
			$order['customer_notified'] = 1;
			$order['comments'] = '';
			$modelOrder->updateStatusForOneOrder ($order['details']['BT']->virtuemart_order_id, $order, true);
			JRequest::setVar ('html', $form);
		} else {
			//$this->processConfirmedOrderPaymentResponse(2, $cart, $order, $html, $method->payment_name, $new_status);
            return $this->processConfirmedOrderPaymentResponse(true, $cart, $order, $form, $this->renderPluginName($method, $order), 'P');
		}
		return null;
    } 

	//Отображение информации о заказе в админке    
	function plgVmOnShowOrderBEPayment($virtuemart_order_id, $virtuemart_payment_id)
	{
		if (!$this->selectedThisByMethodId($virtuemart_payment_id))
		{
	    	return null;
		}
    
		$db = JFactory::getDBO();
		$q = 'SELECT * FROM `' . $this->_tablename . '` '
			. 'WHERE `virtuemart_order_id` = ' . $virtuemart_order_id;
		$db->setQuery($q);
		if (!($paymentTable = $db->loadObject()))
		{
	    	vmWarn(500, $q . " " . $db->getErrorMsg());
	    	return '';
		}
		$this->getPaymentCurrency($paymentTable);

		$html = '<table class="adminlist table">' . "\n";
		$html .=$this->getHtmlHeaderBE();
		$html .= $this->getHtmlRowBE('VMPAYMENT_STT_PAYKEEPER', $paymentTable->payment_name);
		$html .= '</table>' . "\n";
		return $html;
    }

	function getCosts (VirtueMartCart $cart, $method, $cart_prices) {

		if (preg_match ('/%$/', $method->cost_percent_total)) {
			$cost_percent_total = substr ($method->cost_percent_total, 0, -1);
		} else {
			$cost_percent_total = $method->cost_percent_total;
		}
		return ($method->cost_per_transaction + ($cart_prices['salesPrice'] * $cost_percent_total * 0.01));
	}

    protected function checkConditions($cart, $method, $cart_prices)
    {
		    return true;
    }

	//Переход после завершения оплаты   
    function plgVmOnPaymentResponseReceived(  &$html)
    {
		if(self::$flag) return null;
		if(!JRequest::getInt('paykeeper',0)) {
			return NULL;
		}
		if (!class_exists('VirtueMartModelOrders'))
		{
	    	require( JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php' );
		}
		$html = "Оплата прошла успешно";
		if (!class_exists('VirtueMartCart'))
		{
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
		}
		$cart = VirtueMartCart::getCart();
		$cart->emptyCart();
		self::$flag = true; // а это, чтобы несколько раз одно и то же не делать
		return true;
    }

	function plgVmOnUserPaymentCancel()
    {
    	return null;
    }
	
	function plgVmOnPaymentNotification()
    {
		if(!JRequest::getInt('paykeeper',0)) {
			return NULL;
		}
		//Изменение статуса заказа на Confirmed после оплаты счета
		if (!class_exists('VirtueMartModelOrders'))
		{
	    	require( JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php' );
		}
		$pay_data = JRequest::get('post');
		// $this->logInfo(' $pay_data: <pre>'.print_r($pay_data,1).'<br />'.print_r(get_class_methods($pay_data),1).'</pre>', 'message', true);		
		$virtuemart_order_id = $pay_data['orderid'];
		if (!array_key_exists ('orderid', $pay_data) || !isset($pay_data['orderid'])) {
			return NULL; // Another method was selected, do nothing
		} 
		if(!$virtuemart_order_id) return;
		$sum = $pay_data['sum'];
		$notify_signature = $pay_data['key'];

		$payment = $this->getDataByOrderId($virtuemart_order_id);
		$method = $this->getVmPluginMethod($payment->virtuemart_paymentmethod_id);
		if (!isset($method->payment_currency) || !$method->payment_currency)
			$this->getPaymentCurrency($method);
		if (!class_exists('CurrencyDisplay'))
			require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'currencydisplay.php');
		$paymentCurrency        = CurrencyDisplay::getInstance($method->payment_currency);
		$order_model  = new VirtueMartModelOrders();
		$order_info   = $order_model->getOrder($virtuemart_order_id);
		$totalInPaymentCurrency = round($paymentCurrency->convertCurrencyTo($method->payment_currency, $order_info['details']['BT']->order_total, false), 2);	
		$secret_key = $method->secret_key;
		$concat = $pay_data['id'].number_format($sum, 2, ".", "" ).$pay_data['clientid'].$virtuemart_order_id.$secret_key;
		$sig = md5($concat);
		if ($sig != $notify_signature) {
			echo 'Message digest incorrect';
			jexit();
		}
		if ($sum != $totalInPaymentCurrency) {
			echo 'Error sum';
			jexit();
		}
		$new_status = $method->status_success;
		$modelOrder = VmModel::getModel('orders');
		if($order_info['details']['BT']->order_status!=$new_status) {
			$order = array();
			$order['order_status'] = $new_status;
			$order['customer_notified'] =1;
			$order['comments']='PayKeeper';
			$modelOrder->updateStatusForOneOrder($virtuemart_order_id, $order, true);
		}
		echo 'OK ' . md5($pay_data['id'].$secret_key);
		jexit();

		return true;
    }    
    
    function plgVmOnStoreInstallPaymentPluginTable($jplugin_id)
    {
		return $this->onStoreInstallPluginTable($jplugin_id);
    }
    
    public function plgVmOnSelectCheckPayment(VirtueMartCart $cart)
    {
		return $this->OnSelectCheck($cart);
    }
    
	public function plgVmDisplayListFEPayment(VirtueMartCart $cart, $selected = 0, &$htmlIn) {
		$this->cart = $cart;
		return $this->displayListFE($cart, $selected, $htmlIn);
    }
	
	public function getPluginHtml($plugin, $selectedPlugin, $pluginSalesPrice){
		if(isset($this->cart->products) && count($this->cart->products) <= 0) return;
		$pluginmethod_id = $this->_idName;
		$pluginName = $this->_psType . '_name';
		if ($selectedPlugin == $plugin->$pluginmethod_id) {
			$checked = 'checked="checked"';
		} else {
			$checked = '';
		}

		if (!class_exists ('CurrencyDisplay')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'currencydisplay.php');
		}
		$currency = CurrencyDisplay::getInstance ();
		$costDisplay = "";
		if ($pluginSalesPrice) {
			$costDisplay = $currency->priceDisplay ($pluginSalesPrice);
			$costDisplay = '<span class="' . $this->_type . '_cost"> (' . JText::_ ('COM_VIRTUEMART_PLUGIN_COST_DISPLAY') . $costDisplay . ")</span>";
		}
		$s = '';

		$html = '<input type="radio" name="' . $pluginmethod_id . '" id="' . $this->_psType . '_id_' . $plugin->$pluginmethod_id . '"   value="' . $plugin->$pluginmethod_id . '" ' . $checked . ">\n"
			. '<label for="' . $this->_psType . '_id_' . $plugin->$pluginmethod_id . '">' . '<span class="' . $this->_type . '">' . $plugin->$pluginName . $costDisplay . $s. "</span></label>\n";

		return $html; 		
	}
	
    public function plgVmonSelectedCalculatePricePayment(VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name)
    {
		return $this->onSelectedCalculatePrice($cart, $cart_prices, $cart_prices_name);
    }
    
    function plgVmgetPaymentCurrency($virtuemart_paymentmethod_id, &$paymentCurrencyId)
    {

		if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id)))
		{
	    	return null;
		}
		if (!$this->selectedThisElement($method->payment_element))
		{
	    	return false;
		}
	 	$this->getPaymentCurrency($method);

		$paymentCurrencyId = $method->payment_currency;
    }
    
    function logingActions($params)
    {
    	jimport('joomla.error.log');
    	$options = array(
    		'format' => "{DATE}\t{TIME}\t{ORDER}\t{ACTION}"
		);
    	$log = &JLog::getInstance('paykeeper_events.log.php', $options);
    	$log->addEntry(array('ORDER' => $params['ORDER'],'ACTION' => $params['ACTION']));
    }
    
    function plgVmOnCheckAutomaticSelectedPayment(VirtueMartCart $cart, array $cart_prices = array())
    {
		return $this->onCheckAutomaticSelected($cart, $cart_prices);
    }
    
    public function plgVmOnShowOrderFEPayment($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name)
    {
		$this->onShowOrderFE($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
    }
    
    function plgVmonShowOrderPrintPayment($order_number, $method_id)
    {
		return $this->onShowOrderPrint($order_number, $method_id);
    }

    function plgVmDeclarePluginParamsPayment($name, $id, &$data)
    {
		return $this->declarePluginParams('payment', $name, $id, $data);
    }

    function plgVmSetOnTablePluginParamsPayment($name, $id, &$table)
    {
		return $this->setOnTablePluginParams($name, $id, $table);
    }
	function plgVmDeclarePluginParamsPaymentVM3( &$data) {
		return $this->declarePluginParams('payment', $data);
	}

    function getPaymentForm($order, $method)
    {
        $pk_obj = new PaykeeperPayment();

        //set order parameters
        $pk_obj->setOrderParams(
            //sum
            round($order['details']['BT']->order_total, 2),
            //clientid
            $order['details']['BT']->first_name
            . " " . $order['details']['BT']->last_name,
            //orderid
            $order['details']['BT']->virtuemart_order_id,
            //client_email
            $order['details']['BT']->email,
            //client_phone
            $order['details']['BT']->phone_1,
            //service_name
            "",
            //payment form url
            $method->server,
            //secret key
            $method->secret_key
        );

        $redirect_success = isset($method->redirect_success) ? $method->redirect_success : '';
        if ($redirect_success) {
            $pk_obj->order_params['user_result_callback'] =
                str_ireplace('#orderid', $order['details']['BT']->virtuemart_order_id, $redirect_success);
        }

        //TAXES
        $tax_rates = [];
        if ($order['details']['BT']->order_billTax) {
            $bill_tax = json_decode($order['details']['BT']->order_billTax, true);
            foreach ($order['calc_rules'] as $calc_rule) {
                if (!isset($bill_tax[$calc_rule->virtuemart_calc_id])) {
                    continue;
                }
                $calc_value = (int) $calc_rule->calc_value;
                if (!is_null($calc_rule->virtuemart_order_item_id)) {
                    $tax_rates[$calc_rule->virtuemart_order_item_id] = $calc_value;
                } else {
                    $tax_rates[$calc_rule->calc_kind] = $calc_value;
                }
            }
        }

        //GENERATE FZ54 CART
		$item_index = 0;
        foreach ($order['items'] as $order_item) {
            $taxes = array("tax" => "none", "tax_sum" => 0);
            $tax_rate = null;
            if ((float) $order_item->product_final_price <= 0)
                continue;
            $name = $order_item->order_item_name;
            $quantity = floatval($order_item->product_quantity);
            $price = floatval($order_item->product_final_price);
            if ($quantity == 1 && $pk_obj->single_item_index < 0) {
                $pk_obj->single_item_index = $item_index;
            }
            if ($quantity > 1 && $pk_obj->more_then_one_item_index < 0) {
                $pk_obj->more_then_one_item_index = $item_index;
            }
            if (isset($tax_rates[$order_item->virtuemart_order_item_id])) {
                $tax_rate = $tax_rates[$order_item->virtuemart_order_item_id];
            } else if (isset($tax_rates['payment'])) {
                $tax_rate = $tax_rates['payment'];
            }
            if (!is_null($tax_rate)) {
                $taxes = $pk_obj->setTaxes($tax_rate, false);
            }
            $pk_obj->updateFiscalCart($pk_obj->getPaymentFormType(), 
                        $name, $price, $quantity, 0, $taxes["tax"]);
            $item_index++;
        }

        //add shipping parameters to cart
        $shipping_tax = 0;
        $shipping_taxes = array("tax" => "none", "tax_sum" => 0);
        $shipping_tax_rate = null;
        $shipping_price = $order['details']['BT']->order_shipment;
        $shipping_tax = $order['details']['BT']->order_shipment_tax;
        $shipping_price += $shipping_tax;
        $pk_obj->setShippingPrice($shipping_price);
        $shipment_id = $order['details']['BT']->virtuemart_shipmentmethod_id;
        $shipping_name = VmModel::getModel('Shipmentmethod')->getShipment($shipment_id)->shipment_name;
        //check if delivery already in cart
        if (!$pk_obj->checkDeliveryIncluded($pk_obj->getShippingPrice(), $shipping_name) && $pk_obj->getShippingPrice() > 0) {
            if (isset($tax_rates['shipment'])) {
                $shipping_tax_rate = $tax_rates['shipment'];
            } else if (isset($tax_rates['payment'])) {
                $shipping_tax_rate = $tax_rates['payment'];
            }
            if (!is_null($shipping_tax_rate)) {
                $shipping_taxes = $pk_obj->setTaxes($shipping_tax_rate, false);
            }
            $pk_obj->setUseDelivery(); //for precision correct check
            $pk_obj->updateFiscalCart($pk_obj->getPaymentFormType(),
                                    $shipping_name,
                                    $pk_obj->getShippingPrice(), 1, 
                                    0,
                                    $shipping_taxes["tax"]);
            $pk_obj->delivery_index = count($pk_obj->getFiscalCart())-1;
            $pk_obj->fiscal_cart[$pk_obj->delivery_index]['item_type'] = 'service';
        }

        //set discounts
        $pk_obj->setDiscounts($order['details']['BT']->coupon_code != NULL);

        //set extra charge or discount in payment module settings
        $pk_obj->setDiscounts(true);

        //handle possible precision problem
        $pk_obj->correctPrecision();

        //generate payment form
        $to_hash = number_format($pk_obj->getOrderTotal(), 2, ".", "").
            $pk_obj->getOrderParams("clientid").
            $pk_obj->getOrderParams("orderid").
            $pk_obj->getOrderParams("service_name").
            $pk_obj->getOrderParams("client_email").
            $pk_obj->getOrderParams("client_phone").
            $pk_obj->getOrderParams("secret_key");
        $sign = hash ('sha256' , $to_hash);
        $current_lang = JFactory::getLanguage();
        $lang = ($current_lang->getTag() == "en-GB") ? "en" : "ru";
        $pk_obj->setLang($lang);
        return $this->generatePaymentForm($pk_obj, $sign);

    }

    function getPaymentMethod($order)
    {
		if (!($method = $this->getVmPluginMethod($order['details']['BT']->virtuemart_paymentmethod_id)))
		{
	    	return null;
		}
        return $method;
    }

    private function generatePaymentForm($pk_obj, $payment_form_sign) {
        $form = "";
        $delay = ($no_delay) ? 0 : 2000;
        if ($pk_obj->getPaymentFormType() == "create") { //create form
            $inputs = '';
            if ($pk_obj->getOrderParams("user_result_callback")) {
                $inputs .= '
                <input type="hidden" name="user_result_callback" value = "'.$pk_obj->getOrderParams("user_result_callback").'"/>
                ';
            }
            $form = '
                <h3>Сейчас Вы будете перенаправлены на страницу банка.</h3> 
                <form name="pay_form" id="pay_form" action="'.$pk_obj->getOrderParams("form_url").'" accept-charset="utf-8" method="post">
                    <input type="hidden" name="sum" value = "'.$pk_obj->getOrderTotal().'"/>
                    <input type="hidden" name="orderid" value = "'.$pk_obj->getOrderParams("orderid").'"/>
                    <input type="hidden" name="clientid" value = "'.$pk_obj->getOrderParams("clientid").'"/>
                    <input type="hidden" name="client_email" value = "'.$pk_obj->getOrderParams("client_email").'"/>
                    <input type="hidden" name="client_phone" value = "'.$pk_obj->getOrderParams("client_phone").'"/>
                    <input type="hidden" name="service_name" value = "'.$pk_obj->getOrderParams("service_name").'"/>
                    <input type="hidden" name="cart" value = \''.htmlentities($pk_obj->getFiscalCartEncoded(),ENT_QUOTES).'\' />
                    <input type="hidden" name="sign" value = "'.$payment_form_sign.'"/>
                    <input type="hidden" name="lang" value = "'.$pk_obj->getCurrentLang().'"/>
                    ' . $inputs . '
                    <input type="submit" class="btn btn-default" value="Оплатить"/>
                </form>
                <script type="text/javascript">
                    document.forms["pay_form"].submit();
                </script>';
        }
        else { //order form
            $payment_parameters = array(
                "clientid"=>$pk_obj->getOrderParams("clientid"),
                "orderid"=>$pk_obj->getOrderParams('orderid'),
                "sum"=>$pk_obj->getOrderTotal(),
                "client_phone"=>$pk_obj->getOrderParams("phone"),
                "phone"=>$pk_obj->getOrderParams("phone"),
                "client_email"=>$pk_obj->getOrderParams("client_email"),
                "cart"=>$pk_obj->getFiscalCartEncoded());
            $query = http_build_query($payment_parameters);
            if( function_exists( "curl_init" )) { //using curl
                $CR = curl_init();
                curl_setopt($CR, CURLOPT_URL, $pk_obj->getOrderParams("form_url"));
                curl_setopt($CR, CURLOPT_POST, 1);
                curl_setopt($CR, CURLOPT_FAILONERROR, true);
                curl_setopt($CR, CURLOPT_POSTFIELDS, $query);
                curl_setopt($CR, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($CR, CURLOPT_SSL_VERIFYPEER, 0);
                $result = curl_exec( $CR );
                $error = curl_error( $CR );
                if( !empty( $error )) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR:".$error."</span>";
                }
                else {
                    $form = $result;
                }
                curl_close($CR);
            }
            else { //using file_get_contents
                if (!ini_get('allow_url_fopen')) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR: Option allow_url_fopen is not set in php.ini"."</span>";
                }
                else {
                    $query_options = array("https"=>array(
                        "method"=>"POST",
                        "header"=>
                            "Content-type: application/x-www-form-urlencoded",
                        "content"=>$query
                    ));
                    $context = stream_context_create($query_options);
                    $form = file_get_contents($pk_obj->getOrderParams("form_url"), false, $context);
                }
            }
        }
        if ($form  == "") {
            $form = '<h3>Произошла ошибка при инциализации платежа</h3>';
        }

        return $form;
    }
	
}
