<?php

/*
  =====================================================
  # Author: Michael Kochkin
  -----------------------------------------------------
  # https://paykeeper.ru
  -----------------------------------------------------
  # Copyright (c) 2021 PayKeeper
  =====================================================
 */

if (!class_exists('msPaymentInterface')) {
    // for version minishop2 ^3.0.0
    if (file_exists(dirname(dirname(dirname(__FILE__))) . '/model/minishop2/mspaymenthandler.class.php')) {
        require_once dirname(dirname(dirname(__FILE__))) . '/model/minishop2/mspaymenthandler.class.php';
    }
    // for version minishop2 ^4.0.0
    elseif (file_exists(dirname(dirname(dirname(__FILE__))) . '/handlers/mspaymenthandler.class.php')) {
        require_once dirname(dirname(dirname(__FILE__))) . '/handlers/mspaymenthandler.class.php';
    }
}
require_once dirname(__FILE__) . '/paykeeper.common.php';

class Paykeeper extends msPaymentHandler implements msPaymentInterface {
    public $config;
    public $modx;
    public $order;

    function __construct(xPDOObject $object, $config = array()) {
        $this->modx = & $object->xpdo;
        $siteUrl = $this->modx->getOption('site_url');
        $assetsUrl = $this->modx->getOption('minishop2.assets_url', $config, $this->modx->getOption('assets_url') . 'components/minishop2/');
        $paymentUrl = $siteUrl . substr($assetsUrl, 1) . 'payment/paykeeper.php';
        $formUrl = $siteUrl . substr($assetsUrl, 1) . 'payment/paykeeperform.php';
        $payId = null;

        if (isset($_POST['card'])) {
            $payId = $_POST['card'];
            $paySystemId = $this->modx->getOption('ms2_payment_paykeeper_paySystemId');
            preg_match_all("#([^,\s]+):([^,\s]+)#s", $paySystemId, $arrPay);
            unset($arrPay[0]);
            $arrPay = array_combine($arrPay[1], $arrPay[2]);
            foreach ($arrPay as $key => $value) {
                if ($key == $payId) {
                    $payId = $value;
                    break;
                }
            }
        }

        $this->config = array_merge(array(
            'paykeeper_status' => '',
            'paykeeper_order_sort' => '',
            'paykeeper_order_status_id' => '',
            'paykeeper_secret_key' => $this->modx->getOption('ms2_payment_paykeeper_secret_key'),
            'paykeeper_server_url' => $this->modx->getOption('ms2_payment_paykeeper_server_url'),
            //'paykeeper_success_id' => $this->modx->makeUrl($this->modx->getOption('ms2_payment_paykeeper_success_id', null, 0), $context, $params, 'full'),
            //'paykeeper_failure_id' => $this->modx->makeUrl($this->modx->getOption('ms2_payment_paykeeper_failure_id', null, 0), $context, $params, 'full'),
            'paykeeper_tax_id' => '',
            'paykeeper_tax_delivery' => $this->modx->getOption('ms2_payment_paykeeper_tax_delivery'),
            'paykeeper_tax_product' => $this->modx->getOption('ms2_payment_paykeeper_tax_product'),
            'paykeeper_force_discounts_check' => $this->modx->getOption('ms2_payment_paykeeper_force_discounts_check'),
            'paymentUrl' => $paymentUrl,
            'formUrl' => $formUrl,
            'systemId' => $payId,
        ), $config);
    }

    public function send(msOrder $order) {

        $this->setOrder($order);

        $link = $this->setLink($order);
        return $this->success('', array('redirect' => $link));
    }

    private function setOrder(msOrder $order) {
        $orderId = $order->get('id');
        $orderTotal = floatval($order->get('cost'));

        // Получаем адрес заказа
        $orderAddress = $this->modx->getObject('msOrderAddress', ['order_id' => $orderId]);

        // Инициализируем переменные с дефолтными значениями
        $clientId = '';
        $clientUserId = 0;
        $clientPhone = '';
        $clientEmail = '';

        if ($orderAddress) {
            $clientId = $orderAddress->get('receiver') ?: '';
            $clientUserId = $orderAddress->get('user_id') ?: 0;
            $clientPhone = $orderAddress->get('phone') ?: '';
            $clientEmail = $orderAddress->get('email') ?: '';
        }

        // Если email не нашли в адресе, пробуем взять из профиля пользователя
        if (empty($clientEmail)) {
            $userId = $order->get('user_id');
            if ($userId) {
                $userProfile = $this->modx->getObject('modUserProfile', ['internalKey' => $userId]);
                if ($userProfile) {
                    $clientEmail = $userProfile->get('email') ?: '';
                }
            }
        }

        $this->order = [
            'order' => $order,
            'clientid' => $clientId,
            'orderid' => $orderId,
            'service_name' => '',
            'order_total' => $orderTotal,
            'client_id' => $clientUserId,
            'client_email' => $clientEmail,
            'client_phone' => $clientPhone,
        ];
    }

    private function isDelivery(msOrder $order) {
        $delivery = $this->modx->getObject('msDelivery', $order->get('delivery'));
        if (count($delivery->toArray()) > 0) {
            return $delivery;
        } else {
            return false;
        }
    }

    public function callback(msOrder $order) {

        $POST = (isset($_POST) and ! empty($_POST)) ? $_POST : false;

        if (!$POST)
            die('NO POST DATA');

        $sign = md5($POST['id']
            . $POST['sum']
            . $POST['clientid']
            . $POST['orderid']
            . $this->config['paykeeper_secret_key']
        );
        if ($POST["sum"] != $order->get("cost"))
            die("Order sum mismatch!");

        if ($sign != $POST['key'])
            die('HASH MISMATCH');

        $miniShop2 = $this->modx->getService('miniShop2');
        @$this->modx->context->key = 'mgr';
        $miniShop2->changeOrderStatus($order->get('id'), 2);

        echo "OK " . md5($POST['id'] . $this->config['paykeeper_secret_key']);
    }

    private function modxError($text, $request = array()) {
        $this->modx->log(modX::LOG_LEVEL_ERROR, '[miniShop2:Paykeeper] ' . $text . ', request: ' . print_r($request, 1));
        header("HTTP/1.0 400 Bad Request");
        die('ERR: ' . $text);
    }

    private function setLink(msOrder $order) {

        //GENERATING PAYKEEPER PAYMENT FORM
        $pk_obj = new PaykeeperPayment();

        //set order params
        $pk_obj->setOrderParams(
        //sum
            $this->order['order_total'],
            //clientid
            $this->order['clientid'],
            //orderid
            $this->order['orderid'],
            //client_email
            $this->order['client_email'],
            //client_phone
            $this->order['client_phone'],
            //service_name
            $this->order['service_name'],
            //payment form url
            $this->config['paykeeper_server_url'],
            //secret key
            $this->config['paykeeper_secret_key']
        );

        //GENERATE FZ54 CART
        $last_index = 0;
        $cart_data = $this->modx->getCollection('msOrderProduct', array('order_id' => $this->order['orderid']));
        foreach ($cart_data as $product_k => $product_v) {
            $product_id = $this->modx->getObject('msProduct', $product_v->product_id);
            $name = strval($product_id->pagetitle);
            $price = floatval($product_v->price);
            $quantity = floatval($product_v->count);

            // For correctPrecision()
            if ($quantity == 1 && $pk_obj->single_item_index < 0) {
                $pk_obj->single_item_index = $last_index;
            }
            if ($quantity > 1 && $pk_obj->more_then_one_item_index < 0) {
                $pk_obj->more_then_one_item_index = $last_index;
            }

            $tax = $this->getVat($this->config['paykeeper_tax_product']);
            $pk_obj->updateFiscalCart(
                $pk_obj->getPaymentFormType(),
                $name,
                $price,
                $quantity,
                0,
                $tax
            );
            $last_index++;
        }

        //add shipping parameters to cart
        if ($delivery = $this->isDelivery($order)) {
            $pk_obj->setShippingPrice(floatval($order->delivery_cost));
            $shipping_name = isset($delivery->name) ? $delivery->name : 'Доставка';
            if (!$pk_obj->checkDeliveryIncluded($pk_obj->getShippingPrice(), $shipping_name)
                && $pk_obj->getShippingPrice() > 0)
            {
                $tax_delivery = $this->getVat($this->config['paykeeper_tax_delivery']);
                $pk_obj->setUseDelivery(); //for precision correct check
                $pk_obj->updateFiscalCart(
                    $pk_obj->getPaymentFormType(),
                    $shipping_name,
                    $pk_obj->getShippingPrice(),
                    1,
                    0,
                    $tax_delivery
                );
                $pk_obj->delivery_index = $last_index;
                $pk_obj->fiscal_cart[$last_index]['item_type'] = 'service';
            }
        }

        //set discounts
        $pk_obj->setDiscounts($this->config['paykeeper_force_discounts_check'] == "1");

        //handle possible precision problem
        $pk_obj->correctPrecision();

        $to_hash = number_format($pk_obj->getOrderTotal(), 2, ".", "") .
            $pk_obj->getOrderParams("clientid")     .
            $pk_obj->getOrderParams("orderid")      .
            $pk_obj->getOrderParams("service_name") .
            $pk_obj->getOrderParams("client_email") .
            $pk_obj->getOrderParams("client_phone") .
            $pk_obj->getOrderParams("secret_key");
        $sign = hash ('sha256' , $to_hash);

        $request = array(
            'sum' => $pk_obj->getOrderTotal(),
            'clientid' => $pk_obj->getOrderParams("clientid"),
            'orderid' => $pk_obj->getOrderParams("orderid"),
            'client_email' => $pk_obj->getOrderParams("client_email"),
            'client_phone' => $pk_obj->getOrderParams("client_phone"),
            'service_name' => $pk_obj->getOrderParams("service_name"),
            'sign' => $sign,
            'cart' => $pk_obj->getFiscalCartEncoded(),
            'server' => $pk_obj->getOrderParams("form_url"),
            'payment_form_type' => $pk_obj->getPaymentFormType()
        );

        return $this->config['formUrl'] . '?' . http_build_query($request);
    }

    public function getVat($tax_rate)
    {
        return $tax_rate == 'none'? 'none' : 'vat' . (int) $tax_rate;
    }
}