<?php
/**
  *	@author Paykeeper;
  * @version v 2.1  ;
  * @copyright ООО "Пейкипер процессинг";
  */

require_once('paykeeper.class.php');

class ControllerExtensionPaymentPaykeeper extends Controller
{
	public function index()
    {
		$data['button_confirm'] = $this->language->get('button_confirm');
        $data['current_server_name'] = $_SERVER['SERVER_NAME'];

        if (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1)
            || isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https'
            || $this->config->get('config_ssl'))
        {
            $ssl_use = true;
        } else {
            $ssl_use = false;
        }

		$data['url_confirm'] = $this->url->link('extension/payment/paykeeper/gopay', '', $ssl_use);

		$this->load->model('checkout/order');

		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		$payment_parameters = http_build_query(array(
			'orderid' => $this->session->data['order_id'],
			'clientid' => $order_info['email'],
			'sum' => $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false),
			'phone' => $order_info['telephone']
		));

		$data['server'] = $this->config->get('paykeeperserver');
		$data['payment_parameters'] = $payment_parameters;

        return $this->load->view('/extension/payment/paykeeper', $data);
	}

	public function callback()
    {
        // Exit if no POST data is received
		if ($this->request->server['REQUEST_METHOD'] != 'POST') {
            exit;
        }

        // Check if required POST parameters are present
        if (!isset($this->request->post['id']) || !isset($this->request->post['orderid'])) {
            echo "Error! Invalid data";
            exit;
        }

        // Extract and validate key parameters from POST data
        $id = $this->request->post['id'];
        $sum = $this->request->post['sum'];
        $clientid = $this->request->post['clientid'];
        $orderid = $this->request->post['orderid'];
        $key = $this->request->post['key'];
        $secret_seed = $this->config->get('payment_paykeepersecret');

        if (!hash_equals(md5($id . sprintf("%.2lf", $sum) . $clientid . $orderid . $secret_seed), $key)) {
            echo 'Error! Hash mismatch';
            exit;
        }

        $this->load->model('checkout/order');

        // Retrieve order details and validate the order ID
        $order_info = $this->model_checkout_order->getOrder($orderid);
        if (!isset($order_info['order_id'])) {
            echo 'Error! Order was not found';
            exit;
        }

        // Verify that the order total matches the payment amount
        $order_total = $this->currency->format(
            $order_info['total'],
            $order_info['currency_code'],
            $order_info['currency_value'],
            false);
        $order_total_format = number_format($order_total, 2, '.', '');
        $sum_format = number_format($sum, 2, '.', '');
        if ($order_total_format !== $sum_format) {
            echo 'Error! Incorrect order sum!';
            exit;
        }

        // Update order status to reflect successful payment
        $this->model_checkout_order->addOrderHistory($orderid, $this->config->get('payment_paykeeper_order_status_id'));

        // Output success message with confirmation hash
        echo 'OK ' . md5($id . $secret_seed);
        exit;
	}

	public function gopay()
    {
		$this->load->language('checkout/checkout');
		$this->load->language('extension/payment/paykeeper');

		$data['breadcrumbs'] = array();
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_cart'),
			'href' => $this->url->link('checkout/cart')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('checkout/checkout', '', 'SSL')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('paykeeper_title'),
			'href' => $this->url->link('extension/payment/paykeeper/gopay', '', 'SSL')
		);

        $data['heading_title'] = $this->language->get('paykeeper_title');
		$this->document->setTitle($data['heading_title']);

		$this->load->model('checkout/order');

		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

        //generate payment form
        if (isset($_GET['order_id'])) {
            $data["form"] = $this->deffered($_GET['order_id']);
        } else {
            $data["form"] = $this->generatePaymentForm($this->session->data['order_id']);
        }

        $this->response->setOutput($this->load->view('extension/payment/paykeeper_iframe', $data));
	}

    public function deffered($order_id)
    {
        if (!$this->customer->isLogged()) {
            $this->session->data['redirect'] = $this->url->link('account/order/info', 'order_id=' . $order_id, true);
            $this->response->redirect($this->url->link('account/login', '', true));
        }

        $this->load->model('account/order');
        $this->load->model('catalog/product');

        $order_info = $this->model_account_order->getOrder($order_id);

        $pk_obj = new PaykeeperPayment();
        $pk_obj->setOrderParams(
            //sum
            $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false),
            //clientid
            $order_info['firstname'] . " " . $order_info['lastname'],
            //orderid
            $order_info['order_id'],
            //client_email
            $order_info['email'],
            //client_phone
            $order_info['telephone'],
            //service_name
            '',
            //payment form url
            $this->config->get('payment_paykeeperserver'),
            //secret key
            $this->config->get('payment_paykeepersecret')
        );

        //GENERATE FZ54 CART

        $order_products = $this->model_account_order->getOrderProducts($order_id);
        $last_index = 0;
        // включен ли модуль учета налогов
        $total_tax_status = $this->config->get('total_tax_status');
        $total_products_tax_amount = 0;
        foreach ($order_products as $product) {
            $product_tax_rate = 0;
            $product_tax_amount = 0;
            $name = $product['name'];
            $product_info = $this->model_catalog_product->getProduct($product['product_id']);
            $quantity = floatval($product['quantity']);

            if ($total_tax_status && (int)$product_info['tax_class_id'] != 0) {
                $product_tax_rate = $this->_getRate($product['price'], $product_info['tax_class_id']);
                $product_tax_amount = $product['price'] * $product_tax_rate / 100;
                $total_products_tax_amount += $product_tax_amount * $quantity;
            }

            $price = floatval(($product['price'] + $product_tax_amount) * $order_info['currency_value']);

            if ($quantity == 1 && $pk_obj->single_item_index < 0) {
                $pk_obj->single_item_index = $last_index;
            }

            if ($quantity > 1 && $pk_obj->more_then_one_item_index < 0) {
                $pk_obj->more_then_one_item_index = $last_index;
            }

            $taxes = $pk_obj->setTaxes($product_tax_rate);
            $pk_obj->updateFiscalCart(
                $pk_obj->getPaymentFormType(),
                $name,
                $price,
                $quantity,
                0,
                $taxes['tax']
            );

            $last_index++;
        }

        $order_totals = $this->model_account_order->getOrderTotals($order_id);
        $total_tax_amount = 0;
        $shipping_price = 0;
        $shipping_name = '';
        //add shipping parameters to cart
        foreach($order_totals as $total) {
            if ($total['code'] == 'tax') {
                $total_tax_amount += $total['value'];
            } elseif ($total['code'] == 'shipping') {
                $shipping_price = $total['value'];
                $shipping_name = $total['title'];
            } elseif ($total['code'] == 'coupon') {
                $pk_obj->setDiscounts(true);
            }
        }

        $shipping_tax_amount = round($total_tax_amount - $total_products_tax_amount);
        $shipping_tax_rate = 0;
        if($shipping_price > 0){
            if ($total_tax_status && $shipping_tax_amount > 0) {
                $shipping_tax_rate = $shipping_tax_amount / $shipping_price * 100;
            }

            $pk_obj->setShippingPrice(floatval(($shipping_price + $shipping_tax_amount) * $order_info['currency_value']));
            $shipping_taxes = $pk_obj->setTaxes($shipping_tax_rate);

            if (!$pk_obj->checkDeliveryIncluded($pk_obj->getShippingPrice(), $shipping_name)
                && $pk_obj->getShippingPrice() > 0)
            {
                $pk_obj->setUseDelivery(); //for precision correct check
                $pk_obj->updateFiscalCart(
                    $pk_obj->getPaymentFormType(),
                    $shipping_name,
                    $pk_obj->getShippingPrice(),
                    1,
                    0,
                    $shipping_taxes['tax']
                );
                $pk_obj->delivery_index = $last_index;
                $pk_obj->fiscal_cart[$last_index]['item_type'] = 'service';
            }
        }

        $pk_obj->setDiscounts($this->config->get('payment_paykeeper_force_discounts_check') == '1');
        $pk_obj->correctPrecision();

        return $this->_getPaymentHTMLForm($pk_obj);
    }

	public function success() {
		$this->load->language('checkout/checkout');
		$this->load->language('extension/payment/paykeeper');

        //clear cart
        $this->cart->clear();

		$data['heading_title'] = $this->language->get('paykeeper_title');
		$data['breadcrumbs'] = array();
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_cart'),
			'href' => $this->url->link('checkout/cart')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('checkout/checkout', '', 'SSL')
		);
		$data['message'] = $this->language->get('paykeeper_success');

		$this->document->setTitle($data['message']);

		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

        $this->response->setOutput($this->load->view('extension/payment/paykeeper_feedback', $data));
	}

	public function failed() {
		$this->load->language('checkout/checkout');
		$this->load->language('extension/payment/paykeeper');

		$data['heading_title'] = $this->language->get('paykeeper_title');
		$data['breadcrumbs'] = array();
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_cart'),
			'href' => $this->url->link('checkout/cart')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('checkout/checkout', '', 'SSL')
		);

		$data['message'] = $this->language->get('paykeeper_failed');
		$this->document->setTitle($data['message']);
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');
        $this->response->setOutput($this->load->view('extension/payment/paykeeper_feedback', $data));
	}

    /**
     * Confirms the order by updating its status.
     *
     * @return void Updates the order history with the pending status.
     */
    public function confirm()
    {
        // Load the order model
        $this->load->model('checkout/order');

        // Load the settings model
        $this->load->model('setting/setting');

        // Get the default order status ID from the settings
        $default_order_status_id = $this->config->get('config_order_status_id');

        // Add an order history entry with the default status for the newly created order
        $this->model_checkout_order->addOrderHistory($this->session->data['order_id'], $default_order_status_id);
    }

    /**
     * @param $sum
     * @param $tax_class_id
     * @return int
     */
    protected function _getRate($sum, $tax_class_id)
    {
        $max_rate = 0;
        foreach($this->tax->getRates($sum, $tax_class_id) as $tax_data) {
            if ((int)$tax_data['rate'] > $max_rate) {
                $max_rate = (int)$tax_data['rate'];
            }
        }
        return $max_rate;

    }

    protected function _showDebugInfo($obj_to_debug)
    {
        echo "<pre>";
        var_dump($obj_to_debug);
        echo "</pre>";
    }

    public function generatePaymentForm($order_id)
    {
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($order_id);

        $pk_obj = new PaykeeperPayment();
        $pk_obj->setOrderParams(
            //sum
            $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false),
            //clientid
            $order_info['firstname'] . " " . $order_info['lastname'],
            //orderid
            $order_info['order_id'],
            //client_email
            $order_info['email'],
            //client_phone
            $order_info['telephone'],
            //service_name
            '',
            //payment form url
            $this->config->get('payment_paykeeperserver'),
            //secret key
            $this->config->get('payment_paykeepersecret')
        );

        //GENERATE FZ54 CART

        $order_products  = $this->cart->getProducts();
        $last_index = 0;
        // включен ли модуль учета налогов
        $total_tax_status = $this->config->get('total_tax_status');
        foreach ($order_products as $product) {
            $tax_amount = 0;
            $tax_rate = 0;
            $name = $product['name'];

            if ($total_tax_status && (int)$product['tax_class_id'] != 0) {
                $tax_rate = $this->_getRate($product['price'], $product['tax_class_id']);
                $tax_amount = $product['price'] * $tax_rate / 100;
            }

            $price = floatval(($product['price'] + $tax_amount) * $order_info['currency_value']);
            $quantity = floatval($product['quantity']);

            if ($quantity == 1 && $pk_obj->single_item_index < 0) {
                $pk_obj->single_item_index = $last_index;
            }

            if ($quantity > 1 && $pk_obj->more_then_one_item_index < 0) {
                $pk_obj->more_then_one_item_index = $last_index;
            }

            $taxes = $pk_obj->setTaxes($tax_rate);
            $pk_obj->updateFiscalCart(
                $pk_obj->getPaymentFormType(),
                $name,
                $price,
                $quantity,
                0,
                $taxes['tax']
            );

            $last_index++;
        }

        //add shipping parameters to cart
        if (array_key_exists('shipping_method', $this->session->data)) {
            $shipping_method = $this->session->data['shipping_method'];
            $shipping_tax_rate = 0;
            $shipping_tax_amount = 0;

            if ($total_tax_status && $shipping_method['tax_class_id'] != 0) {
                $shipping_tax_rate = $this->_getRate($shipping_method['cost'], $shipping_method['tax_class_id']);
                $shipping_tax_amount = $shipping_method['cost'] * $shipping_tax_rate / 100;
            }

            $pk_obj->setShippingPrice(floatval(($shipping_method['cost'] + $shipping_tax_amount) * $order_info['currency_value']));
            $shipping_taxes = $pk_obj->setTaxes($shipping_tax_rate);
            $shipping_name = $shipping_method['title'];

            if (!$pk_obj->checkDeliveryIncluded($pk_obj->getShippingPrice(), $shipping_name)
                && $pk_obj->getShippingPrice() > 0)
            {
                $pk_obj->setUseDelivery(); //for precision correct check
                $pk_obj->updateFiscalCart(
                    $pk_obj->getPaymentFormType(),
                    $shipping_name,
                    $pk_obj->getShippingPrice(),
                    1,
                    0,
                    $shipping_taxes['tax']
                );
                $pk_obj->delivery_index = $last_index;
                $pk_obj->fiscal_cart[$last_index]['item_type'] = 'service';
            }
        }

        $pk_obj->setDiscounts(array_key_exists("coupon", $this->session->data)
            || $this->config->get('payment_paykeeper_force_discounts_check') == '1');
        $pk_obj->correctPrecision();

        return $this->_getPaymentHTMLForm($pk_obj);
    }

    protected function _getPaymentHTMLForm($pk_obj)
    {
        //generate payment form
        $form = '';
        if ($pk_obj->getPaymentFormType() == 'create') { //create form
            $to_hash = number_format($pk_obj->getOrderTotal(), 2, ".", "") .
                $pk_obj->getOrderParams('clientid')     .
                $pk_obj->getOrderParams('orderid')      .
                $pk_obj->getOrderParams('service_name') .
                $pk_obj->getOrderParams('client_email') .
                $pk_obj->getOrderParams('client_phone') .
                $pk_obj->getOrderParams('secret_key');
            $sign = hash ('sha256' , $to_hash);
            $form = '
<h3>Сейчас Вы будете перенаправлены на страницу банка.</h3>
<form name="payment" id="pay_form" action="'.$pk_obj->getOrderParams("form_url").'" accept-charset="utf-8" method="post">
    <input type="hidden" name="sum" value = "'.$pk_obj->getOrderTotal().'"/>
    <input type="hidden" name="orderid" value = "'.$pk_obj->getOrderParams("orderid").'"/>
    <input type="hidden" name="clientid" value = "'.$pk_obj->getOrderParams("clientid").'"/>
    <input type="hidden" name="client_email" value = "'.$pk_obj->getOrderParams("client_email").'"/>
    <input type="hidden" name="client_phone" value = "'.$pk_obj->getOrderParams("client_phone").'"/>
    <input type="hidden" name="service_name" value = "'.$pk_obj->getOrderParams("service_name").'"/>
    <input type="hidden" name="cart" value = \''.htmlentities($pk_obj->getFiscalCartEncoded(), ENT_QUOTES).'\' />
    <input type="hidden" name="sign" value = "'.$sign.'"/>
    <input type="submit" id="button-confirm" value="Оплатить"/>
</form>
<script text="javascript">
    window.onload = function() {
        setTimeout(sendForm, 2000);
    } 
    function sendForm() {
        document.getElementById("pay_form").submit();
    }
</script>';
        } else { //order form
            $payment_parameters = array(
                'clientid' => $pk_obj->getOrderParams('clientid'),
                'orderid' => $pk_obj->getOrderParams('orderid'),
                'sum' => $pk_obj->getOrderTotal(),
                'phone' => $pk_obj->getOrderParams('phone'),
                'client_email' => $pk_obj->getOrderParams('client_email'),
                'cart' => $pk_obj->getFiscalCartEncoded()
            );
            $query = http_build_query($payment_parameters);
            $query_options = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => $query
                )
            );
            $context = stream_context_create($query_options);
            if(function_exists('curl_init')) { // using curl
                $CR = curl_init();
                curl_setopt($CR, CURLOPT_URL, $pk_obj->getOrderParams('form_url'));
                curl_setopt($CR, CURLOPT_POST, 1);
                curl_setopt($CR, CURLOPT_FAILONERROR, true);
                curl_setopt($CR, CURLOPT_POSTFIELDS, $query);
                curl_setopt($CR, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($CR, CURLOPT_SSL_VERIFYPEER, 0);
                $result = curl_exec( $CR );
                $error = curl_error( $CR );
                if(!empty($error)) {
                    $form = '<br/><p>INTERNAL ERROR:'.$error.'</p>';
                } else {
                    $form = $result;
                }
                curl_close($CR);
            } else { // using file_get_contents
                if (!ini_get('allow_url_fopen')) {
                    $form = '<br/><p>INTERNAL ERROR: Option allow_url_fopen is not set in php.ini</p>';
                } else {
                    $form = file_get_contents($pk_obj->getOrderParams("form_url"), false, $context);
                }
            }
        }
        if ($form == '') {
            $form = '<br/><p>Произошла ошибка при инциализации платежа</p>';
        }

        return $form;
    }
}



