<?php
namespace Paykeeper\PkPayShopaholic\Http\Controllers;

use Paykeeper\PkPayShopaholic\Classes\Helper\PaykeeperHelper;
use Lovata\OrdersShopaholic\Models\Order;
use Illuminate\Routing\Controller ;
use Illuminate\Http\Request;
use Lovata\OrdersShopaholic\Models\PaymentMethod;
use \Lovata\OrdersShopaholic\Models\ShippingType;
use Illuminate\Support\Facades\Validator;

class PaymentController extends Controller
{
    public function pay(Request $request): string
    {
        $order=Order::find($request->id);
        $order_position_collection= $order->order_position()->get();
        $order_total = $order->total_price_value;
        $clientid = $order->getProperty('last_name')?$order->getProperty('last_name'):'';
        $clientid .= ' ';
        $clientid .= $order->getProperty('name')?$order->getProperty('name'):'';
        $orderid = $order->id;
        $client_email = $order->getProperty('email')?$order->getProperty('email'):'';
        $client_phone = $order->getProperty('phone')?$order->getProperty('phone'):'';
        $form_url = PaymentMethod::query()->where('gateway_id','paykeeper')->first()->gateway_property['payment_url'];
        $secret_key = PaymentMethod::query()->where('gateway_id','paykeeper')->first()->gateway_property['secret_key'];
        $force_discounts = PaymentMethod::query()->where('gateway_id','paykeeper')->first()->gateway_property['force_discounts'];
        $service_name = "";
        $pk_helper = new PaykeeperHelper();
        $pk_helper->setOrderParams(
            $order_total,
            trim($clientid),
            $orderid,
            $client_email,
            $client_phone,
            $service_name,
            $form_url,
            $secret_key
        );
        $last_index = 0;
        foreach ($order_position_collection as $order_position_item) {
            $name = $order_position_item->offer->name;
            $taxes = $pk_helper->setTaxes($order_position_item->tax_percent);
            $price = $order_position_item->price;
            $quantity = $order_position_item->quantity;
            if ($quantity == 1 && $pk_helper->single_item_index < 0) {
                $pk_helper->single_item_index = $last_index;
            }
            if ($quantity > 1 && $pk_helper->more_then_one_item_index < 0) {
                $pk_helper->more_then_one_item_index = $last_index;
            }
            $pk_helper->updateFiscalCart(
                $pk_helper->getPaymentFormType(),
                $name,
                $price,
                $quantity,
                0,
                $taxes["tax"]
            );
            $last_index++;
        }

        if ($order->shipping_price > 0) {
            $delivery_name = ShippingType::query()->find($order->shipping_type_id)->name;
            $delivery_price = $order->shipping_price;
            $delivery_tax_rates = $pk_helper->setTaxes($order->shipping_tax_percent);
            $pk_helper->setShippingPrice($delivery_price);
            $pk_helper->setUseDelivery();
            $pk_helper->updateFiscalCart(
                $pk_helper->getPaymentFormType(),
                $delivery_name,
                $pk_helper->getShippingPrice(),
                1,
                0,
                $delivery_tax_rates["tax"]
            );
            $pk_helper->delivery_index = $last_index;
            $pk_helper->fiscal_cart[$last_index]['item_type'] = 'service';
        }

        $pk_helper->setDiscounts($force_discounts);

        $pk_helper->correctPrecision();

        $fiscal_cart_encoded = json_encode($pk_helper->getFiscalCart());
        if ($pk_helper->getPaymentFormType() == "create") { //create form
            $to_hash = number_format($pk_helper->getOrderTotal(), 2, ".", "") .
                $pk_helper->getOrderParams("clientid")     .
                $pk_helper->getOrderParams("orderid")      .
                $pk_helper->getOrderParams("service_name") .
                $pk_helper->getOrderParams("client_email") .
                $pk_helper->getOrderParams("client_phone") .
                $pk_helper->getOrderParams("secret_key");
            $sign = hash ('sha256' , $to_hash);
            $form = '
                <h3>Сейчас Вы будете перенаправлены на страницу банка.</h3>
                <form name="payment" id="pay_form" action="'.$pk_helper->getOrderParams("form_url").'" accept-charset="utf-8" method="post">
                    <input type="hidden" name="sum" value = "'.$pk_helper->getOrderTotal().'"/>
                    <input type="hidden" name="orderid" value = "'.$pk_helper->getOrderParams("orderid").'"/>
                    <input type="hidden" name="clientid" value = "'.$pk_helper->getOrderParams("clientid").'"/>
                    <input type="hidden" name="client_email" value = "'.$pk_helper->getOrderParams("client_email").'"/>
                    <input type="hidden" name="client_phone" value = "'.$pk_helper->getOrderParams("client_phone").'"/>
                    <input type="hidden" name="service_name" value = "'.$pk_helper->getOrderParams("service_name").'"/>
                    <input type="hidden" name="cart" value = \''.htmlentities($fiscal_cart_encoded,ENT_QUOTES).'\' />
                    <input type="hidden" name="sign" value = "'.$sign.'"/>
                    <input type="submit" id="button-confirm" value="Оплатить"/>
                </form>
                <script text="javascript">
                    document.getElementById("pay_form").submit();
                </script>';
            return $form;
        }
        else return 'Используйте платежный адрес заканчивающий на /create';


    }
    public function callback(Request $request): string
    {
        if (!isset($request->id, $request->sum, $request->clientid, $request->orderid, $request->key)) {
            return 'Not enough necessary parameters';
        }
        $validator = Validator::make($request->all(), [
            'id' => 'required|integer|min:1',
            'sum' => 'required|numeric|min:0.01',
            'clientid' => 'sometimes|string|max:255',
            'orderid' => 'sometimes|string|max:100',
            'key' => ['required', 'string', 'regex:/^[a-f0-9]{32}$/']
        ]);
        if ($validator->fails()) {
            return 'The given data did not pass validation';
        }

        $id = $request->id;
        $sum = $request->sum;
        $clientid = $request->clientid;
        $orderid = $request->orderid;
        $key = $request->key;
        $secret_key = PaymentMethod::query()->where('gateway_id','paykeeper')->first()->gateway_property['secret_key'];
        $order = Order::find($orderid);
        if (is_null($order)) {
            return 'Order not exist';
        }
        if ($order->total_price_value != $sum) {
            return 'Sum is not valid';
        }
        $userkey = md5($id . sprintf ("%.2lf", $sum) . $clientid . $orderid . $secret_key);
        if (!hash_equals($userkey, $key)) {
            return 'Error! Hash mismatch';
        }
        $order->status = $order->payment_method->after_status;
        $order->save();
        return 'OK ' . md5($id . $secret_key);
    }
}
