<?php
/**
 * @version      1.0.0 14.02.2022
 * @author       paykeeper
 * @package      Jshopping
 * @copyright    Copyright (C) PayKeeper Ltd
 * @license      GNU/GPL
 */
defined('_JEXEC') or die('Restricted access');

class pm_sttpaykeeper extends PaymentRoot{

    function showPaymentForm($params, $pmconfigs){
        include(dirname(__FILE__)."/paymentform.php");
    }

    function showAdminFormParams($params){
        $array_params = array('user_id', 'form_url', 'secret', 'transaction_end_status', 'transaction_pending_status', 'transaction_failed_status', 'server');
        foreach ($array_params as $key){
            if (!isset($params[$key])) $params[$key] = '';
        }
        $orders = class_exists('JModelLegacy')
            ? JModelLegacy::getInstance('orders', 'JshoppingModel')
            : JSFactory::getModel("orders");

        $JHTML = class_exists('JHTML')
            ? JHTML::class
            : Joomla\CMS\HTML\HTMLHelper::class;

        $JURI = class_exists('JURI')
            ? JURI::class
            : Joomla\CMS\Uri\Uri::class;

        JSFactory::loadExtAdminLanguageFile('sttpaykeeper');
        include(dirname(__FILE__)."/adminparamsform.php");
    }

    function checkTransaction($params, $order, $act){

        $input = \Joomla\CMS\Factory::getApplication()->input;
        $paykeeper_data = $input->post->getArray();
        if (!array_key_exists ('orderid', $paykeeper_data) || !isset($paykeeper_data['orderid'])) {
            return array(0,'error orderid');
        }
        $order_id = $paykeeper_data['orderid'];
        $sum = $paykeeper_data['sum'];
        $notify_signature = $paykeeper_data['key'];

        $totalInPaymentCurrency = round($order->order_total/$order->currency_exchange,2);

        if ($sum != $totalInPaymentCurrency) {
            return array(0,'error sum. Order ID '.$order->order_id. ' error: '.$sum. ' <> '.$totalInPaymentCurrency);
        }
        $secret_key = $params['secret'];
        $concat = $paykeeper_data['id'].sprintf("%.2lf", $sum).$paykeeper_data['clientid'].$order_id.$secret_key;
        $sig = md5($concat);
        if (strcmp( $sig, $notify_signature) !== 0 ) {
            return array(0,'error signature. Order ID '.$order->order_id. ' $sig='.$sig. ' $notify_signature='.$notify_signature);
        }

        $hash = md5($paykeeper_data['id'] . $secret_key);
        echo 'OK ' . $hash;
        return array(1, $order_id);
    }

    function nofityFinish($pmconfigs, $order, $rescode)
    {
        return $this->notifyFinish($pmconfigs, $order, $rescode);
    }
    function notifyFinish($pmconfigs, $order, $rescode)
    {
        if($rescode==1) {
            jexit();
        }
        return;
    }

    function showEndForm($params, $order){

        $jshopConfig = \JSFactory::getConfig();
        $pm_method = $this->getPmMethod();
        $JText = class_exists('JText')
            ? \JText::class
            : Joomla\CMS\Language\Text::class;
        $item_name = sprintf($JText::_('JSHOP_PAYMENT_NUMBER'), $order->order_number);

        $sum = round($order->order_total/$order->currency_exchange,2);
        $email = '';
        $name = '';
        if (isset($order->email)) {
            $email = $order->email;
        }
        if (isset($order->name)) {
            $name = $order->name;
        }

        if (!$email || !$name) {
            $JFactory = class_exists('JFactory')
                ? \JFactory::class
                : Joomla\CMS\Factory::class;
            $user = $JFactory::getUser();
            if (isset($user->id)) {
                if (!$email && isset($user->email)) {
                    $email = $user->email;
                }
                if (!$name && isset($user->name)) {
                    $name = $user->name;
                }
            }
        }
        $action = '1';
        $post_variables = Array(
            'clientid'			=> $email,
            'client_email'		=> $email,
            'orderid'			=> $order->order_id,
            'sum'				=> number_format($sum, 2, '.', '')
        );
        if(isset($order->phone) && $order->phone) {
            $post_variables['phone']=$order->phone;
        }
        $payment_parameters = http_build_query($post_variables);
        $url = $params['form_url'];
        $options = array("http"=>array(
            "method"=>"POST",
            "header"=>"Content-type: application/x-www-form-urlencoded",
            "content"=>$payment_parameters
        ));
        $context = stream_context_create($options);

        // Отображаем форму выбора способа оплаты.
        // С неё пользователь, выбрав способ оплаты, переходит на сайт нужной платёжной системы.
        $html = file_get_contents($url, false, $context);
        echo $html;

    }

    function getUrlParams($pmconfigs){
        $params = array();
        $JFactory = class_exists('JFactory')
            ? \JFactory::class
            : Joomla\CMS\Factory::class;
        $params['order_id'] = $JFactory::getApplication()->input->getInt("orderid");
        $params['hash'] = "";
        $params['checkHash'] = 0;
        $params['checkReturnParams'] = 0;
        return $params;
    }
}
?>