<?php

include_once __DIR__ . \DIRECTORY_SEPARATOR . 'vendor/Paykeeper_methodHelper.class.php';

/*
 * Plugins "PayKeeper" for Shop-Script
 *
 * @author PayKeeper
 * @name PayKeeper
 * @description Плагин оплаты через PayKeeper.
 *
 * Поля, доступные в виде параметров настроек плагина, указаны в файле lib/config/settings.php.
 * @property-read string $pk_url_link
 * @property-read string $pk_secret_key
*/
class paykeeperPayment extends waPayment implements waIPayment
{
    private static $separator = '|';
    /**
     * Возвращаем валюту (Доступно только RUB)
     *
     * @return string
     */
    public function allowedCurrency()
    {
        return $currency = 'RUB';
    }

    /**
     * Выводим свой шаблон страницы оплаты и перенаправляем клиента на страницу оплаты
     *
     * @param $payment_form_data
     * @param $order_data
     * @param $form_html
     * @return mixed
     */
    public function payment($payment_form_data, $order_data, $form_html = true)
    {
        $pk_obj = new Paykeeper_methodHelper;

        // Заполняем обязательный элемент данных с описанием заказа
        if (empty($order_data['description'])) {
            $order_data['description'] = 'Заказ '.$order_data['order_id'];
        }

        // Вызываем класс-обертку, чтобы гарантировать использование данных в правильном формате
        $order = waOrder::factory($order_data);

        $client_phone = '';
        $client_email = '';
        $clientid = '';
        if (!empty($order_data['contact_id'])) {
            $contact = new waContact($order_data['contact_id']);
            $client_phone = preg_replace('/^\s*\+\s*7/', '', $contact->get('phone.mobile', 'default'));
            $client_phone = preg_replace('/[^\d]/', '', $client_phone);
            $client_email = $contact->get('email', 'default');
            $clientid = isset($contact['name']) ? $contact['name'] : '';
        }

        // Set order parameters
        $orderid = $order_data["id_str"] . self::$separator .
            $order_data["order_id"] . self::$separator .
            $this->app_id . self::$separator .
            $this->merchant_id;

        $pk_obj->setOrderParams(
            $order->total,
            $clientid,
            $orderid,
            $client_email,
            $client_phone,
            "",
            $this->pk_url_link,
            $this->pk_secret_key
        );

        // GENERATE FZ54 CART
        $cart_data = $order_data["items"];
        $last_index = 0;

        foreach ($cart_data as $cart_item) {

            // Формируем данные для ТРУ кода
            $tru_code = '';
            if (class_exists('shopProduct') && !empty($this->pk_tru_code_field)) {
                $product = new shopProduct($cart_item['product_id']);
                if (method_exists($product, 'getSkuFeatures')) {
                    $featuresSkuProduct = $product->getSkuFeatures();
                    if (!empty($featuresSkuProduct[$this->pk_tru_code_field])) {
                        $tru_code = $featuresSkuProduct[$this->pk_tru_code_field];
                    }
                }
                if (!$tru_code && method_exists($product, 'getFeatures')) {
                    $featuresProduct = $product->getFeatures();
                    if (!empty($featuresProduct[$this->pk_tru_code_field])) {
                        $tru_code = $featuresProduct[$this->pk_tru_code_field];
                    }
                }

            }

            $name = $cart_item["name"];
            $quantity = $cart_item["quantity"];

            if (isset($cart_item["tax_rate"])) {
                $pk_obj->setUseTaxes();

                if ($cart_item["tax_included"] == 0) {
                    $price = $cart_item["price"] + $cart_item["price"]/100*$cart_item["tax_rate"];
                    $pk_obj->setOrderTotal($order->total+$order->tax);
                } else {
                    $price = $cart_item["price"];
                }
            } else {
                $price = $cart_item["price"];
            }

            if ($quantity == 1 && $pk_obj->single_item_index < 0) {
                $pk_obj->single_item_index = $last_index;
            }
            if ($quantity > 1 && $pk_obj->more_then_one_item_index < 0) {
                $pk_obj->more_then_one_item_index = $last_index;
            }

            $tax_rate = isset($cart_item["tax_rate"]) ? $cart_item["tax_rate"] : 0;
            $taxes = $pk_obj->setTaxes($tax_rate);

            $pk_obj->updateFiscalCart(
                $pk_obj->getPaymentFormType(),
                $name,
                $price,
                $quantity,
                0,
                $taxes["tax"]
            );

            if ($tru_code) {
                $pk_obj->fiscal_cart[$last_index]['tru_code'] = $tru_code;
            }

            $last_index++;
        }

        $shipping_tax_rate = $order["shipping_tax_rate"];

        if ($order["shipping_tax_included"] == 0) {
            $shipping_tax_final = $order["shipping"] + ($shipping_tax_rate * $order["shipping"])/100;
        } else {
            $shipping_tax_final = $order["shipping"];
        }

        $pk_obj->setShippingPrice($shipping_tax_final);
        $shipping_name = $order["shipping_name"];
        $shipping_taxes = $pk_obj->setTaxes($shipping_tax_rate);

        if ($pk_obj->getShippingPrice() > 0) {
            $pk_obj->setUseDelivery();
            $pk_obj->updateFiscalCart(
                $pk_obj->getPaymentFormType(),
                $shipping_name,
                $pk_obj->getShippingPrice(),
                1,
                0,
                $shipping_taxes["tax"]
            );
            $pk_obj->delivery_index = $last_index;
            $pk_obj->fiscal_cart[$last_index]['item_type'] = 'service';
        }

        $pk_obj->setDiscounts(array_key_exists("coupon_discount", $order["params"]) || $this->pk_force_discounts_check ==1);

        $pk_obj->correctPrecision();

        $form = "";

        if ($pk_obj->getPaymentFormType() == "create") { // Create form
            $to_hash = $this->getSumFormat($pk_obj->getOrderTotal()) .
                $pk_obj->getOrderParams("clientid")            .
                $pk_obj->getOrderParams("orderid")             .
                $pk_obj->getOrderParams("service_name")        .
                $pk_obj->getOrderParams("client_email")        .
                $pk_obj->getOrderParams("client_phone")        .
                $pk_obj->getOrderParams("secret_key");
            $sign = hash ('sha256' , $to_hash);

            $this->setSubmitButtonCSSClass("large bold");
            if ($this->pk_autoredirect) {
                $form .= '<h3>Сейчас Вы будете перенаправлены на страницу банка.</h3>';
            } else {
                $form .= '<h3>Нажмите кнопку Оплатить для перенаправления на страницу банка.</h3>';
            }
            $form .= '
                <form name="pk_payform" id="pk_payform" action="'.$pk_obj->getOrderParams("form_url").'" accept-charset="utf-8" method="post">
                    <input type="hidden" name="sum" value = "'.$pk_obj->getOrderTotal().'"/>
                    <input type="hidden" name="orderid" value = "'.$pk_obj->getOrderParams("orderid").'"/>
                    <input type="hidden" name="clientid" value = "'.$pk_obj->getOrderParams("clientid").'"/>
                    <input type="hidden" name="client_email" value = "'.$pk_obj->getOrderParams("client_email").'"/>
                    <input type="hidden" name="client_phone" value = "'.$pk_obj->getOrderParams("client_phone").'"/>
                    <input type="hidden" name="service_name" value = "'.$pk_obj->getOrderParams("service_name").'"/>
                    <input type="hidden" name="cart" value = \''.htmlentities($pk_obj->getFiscalCartEncoded(),ENT_QUOTES).'\' />
                    <input type="hidden" name="sign" value = "'.$sign.'"/>
                    <input type="submit" class="'.$this->getSubmitButtonCSSClass().'" value="Оплатить"/>
                </form>
                ';
            if ($this->pk_autoredirect) {
                $form .= '
                <script type="text/javascript">
                    document.forms["pk_payform"].submit();
                </script>';
            }

        } else {
            $payment_parameters = array(
                "clientid"=>$pk_obj->getOrderParams("clientid"),
                "orderid"=>$pk_obj->getOrderParams('orderid'),
                "sum"=>$pk_obj->getOrderTotal(),
                "phone"=>$pk_obj->getOrderParams("phone"),
                "client_email"=>$pk_obj->getOrderParams("client_email"),
                "cart"=>$pk_obj->getFiscalCartEncoded());
            $query = http_build_query($payment_parameters);
            if( function_exists( "curl_init" ))
            {
                $CR = curl_init();
                curl_setopt($CR, CURLOPT_URL, $pk_obj->getOrderParams("form_url"));
                curl_setopt($CR, CURLOPT_POST, 1);
                curl_setopt($CR, CURLOPT_FAILONERROR, true);
                curl_setopt($CR, CURLOPT_POSTFIELDS, $query);
                curl_setopt($CR, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($CR, CURLOPT_SSL_VERIFYPEER, 0);
                $result = curl_exec( $CR );
                $error = curl_error( $CR );
                if (!empty($error)) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR:".$error."</span>";
                } else {
                    $form = $result;
                }
                curl_close($CR);
            } else {
                if (!ini_get('allow_url_fopen')) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR: Option allow_url_fopen is not set in php.ini"."</span>";
                } else {
                    $context_options = array (
                        'http' => array (
                            'method' => 'POST',
                            'header'=> "Content-type: application/x-www-form-urlencoded\r\n"
                                . "Content-Length: " . strlen($query) . "\r\n",
                            'content' => $query
                        )
                    );
                    $context = stream_context_create($context_options);
                    $form = file_get_contents($pk_obj->getOrderParams("form_url"), false, $context);
                }
            }
        }
        if ($form == '') {
            $form = '<h3>Произошла ошибка при инциализации платежа</h3>';
        }

        // Используем свой шаблон (по желанию можно применить любой стиль, дабы подходил к дизайну)
        $view = wa()->getView();
        $view->assign('form_html', $form);
        return $view->fetch($this->path.'/templates/payment.html');
    }

    /**
     * Инициируем callBack Функцию и подготавливаем переменные
     *
     * @param $request
     * @return mixed
     */
    protected function callbackInit($request)
    {
        $requiredKeys = ['id', 'sum', 'clientid', 'orderid', 'key'];
        $missing = [];
        foreach ($requiredKeys as $key) {
            if (empty($request[$key])) $missing[] = $key;
        }

        if (!empty($missing)) {
            $message = 'empty required field(s)';
            self::log($this->id, array('error' => $message));
            die($message . ': ' . implode(', ', $missing));
        }

        $orderid_data = $this->parseOrderId($request["orderid"]);

        $this->order_id = $orderid_data[1];
        $this->app_id = $orderid_data[2];
        $this->merchant_id = $orderid_data[3];

        return parent::callbackInit($request);
    }

    /**
     * Выполняем проверку и выводим сообщения
     * Так же пишем в лог, или обновляем статус заказа в случае успеха
     *
     * @param $request
     * @return void
     */
    protected function callbackHandler($request)
    {
        // Приводим данные о транзакции к универсальному виду
        $transaction_data = $this->formalizeData($request);

        // ВЫПОЛНЯЕМ ПРОВЕРКИ
        $pk_create = md5($request['id'] . $this->getSumFormat($request['sum']) . $request['clientid'] .
            $request['orderid'] . $this->pk_secret_key);

        // Проверка хэша
        if (!hash_equals($pk_create, $request['key'])) {
            $message = 'Message digest incorrect';
            self::log($this->id, array('error' => $message));
            echo $message;
            exit();
        }

        // Если все хорошо выполняем и выводим ответ для ПС
        $transaction_data['type'] = self::OPERATION_AUTH_CAPTURE;
        $transaction_data['state'] = self::STATE_CAPTURED;
        $callback_method = self::CALLBACK_PAYMENT;
        $transaction_data = $this->saveTransaction($transaction_data, $request);
        $result = $this->execAppCallback($callback_method,$transaction_data);

        if (empty($result['result'])) {
            $message = !empty($result['error']) ? $result['error'] : 'wa transaction error';
            self::log($this->id, array('error' => $message));
            echo $message;
            exit();
        }

        self::log($this->id, array('result' => 'success'));
        echo 'OK ' . md5($request['id'] . $this->pk_secret_key);
        exit();
    }


    /**
     * @param $class_string
     * @return void
     */
    protected function setSubmitButtonCSSClass($class_string)
    {
        $this->submit_button_class = $class_string;
    }

    /**
     * @return mixed
     */
    protected function getSubmitButtonCSSClass()
    {
        return $this->submit_button_class;
    }

    /**
     * @param $orderId
     * @return false|string[]
     */
    protected function parseOrderId($orderId)
    {
        return explode(self::$separator, $orderId);
    }

    /**
     * Подготавливаем массив для вставки в БД и определяем тип
     *
     * @param $request
     * @return mixed
     */
    protected function formalizeData($request) {
        // формируем полный список полей, относящихся к транзакциям, которые обрабатываются платежной системой payKeeper
        $fields = array(
            'id',
            'sum',
            'orderid',
            'clientid',
            'key',
        );
        foreach ($fields as $f) {
            if (!isset($request[$f])) {
                $request[$f] = null;
            }
        }

        $orderid_data = $this->parseOrderId($request["orderid"]);

        // выполняем базовую обработку данных
        $transaction_data = parent::formalizeData($request);
        //Тип транзацкии
        $transaction_data['type'] = self::OPERATION_AUTH_CAPTURE;
        // идентификатор транзакции, присвоенный платежной системой
        $transaction_data['native_id'] = $request['id'];
        // номер заказа
        $transaction_data['order_id'] = $orderid_data[1];
        // сумма заказа
        $transaction_data['amount'] = $this->getSumFormat($request['sum']);
        // идентификатор валюты заказа
        $transaction_data['currency_id'] = $this->allowedCurrency();
        $transaction_data['result'] = 1;
        $transaction_data['view_data'] = 'Оплачено через PayKeeper - статус ответа: success';
        $transaction_data['state'] = self::STATE_CAPTURED;

        return $transaction_data;
    }

    /**
     * Converting the amount to the format
     * @param $sum
     * @return string
     */
    protected function getSumFormat($sum)
    {
        return number_format($sum, 2, '.', '');
    }
}