<?php
/**
 * Plugin Name: WooCommerce PayKeeper Plugin
 * Plugin URI: https://docs.paykeeper.ru/cms/
 * Description: Модуль приема платежей через платформу PayKeeper.
 * Version: 2.1.1
 * Author: PayKeeper development department
 * Author URI: https://paykeeper.ru/
 * Requires at least: 4.2
 * License: GPL2 or Later
 */

if (!defined('ABSPATH')) {
    //Exit if accessed directly
    exit;
}


if (!class_exists('WC_PayKeeper_Gateway_Addon')) {

	class WC_PayKeeper_Gateway_Addon
    {
		var $version = '2.1.1';
		var $plugin_url;
		var $plugin_path;

		function __construct()
        {
			$this->define_constants();
			$this->loader_operations();
		}

		function define_constants()
        {
			define('WC_PK_ADDON_VERSION', $this->version);
			define('WC_PK_ADDON_URL', $this->plugin_url());
			define('WC_PK_ADDON_PATH', $this->plugin_path());
		}

		function loader_operations()
        {
			add_action('plugins_loaded', array(&$this, 'plugins_loaded_handler')); //plugins loaded hook		
		}

		function plugins_loaded_handler()
        {
			//Runs when plugins_loaded action gets fired
			include_once('paykeeper-gateway-class.php');
			add_filter('woocommerce_payment_gateways', array(&$this, 'init_paykeeper_gateway'));
		}

		function plugin_url()
        {
			if ($this->plugin_url)
				return $this->plugin_url;

			return $this->plugin_url = plugins_url(basename(plugin_dir_path(__FILE__)), basename(__FILE__));
		}

		function plugin_path()
        {
			if ($this->plugin_path)
				return $this->plugin_path;

			return $this->plugin_path = untrailingslashit(plugin_dir_path(__FILE__));
		}

		function init_paykeeper_gateway($methods)
        {
			array_push($methods, 'WC_PK_Gateway');
			return $methods;
		}
	}
}

$GLOBALS['WC_PayKeeper_Gateway_Addon'] = new WC_PayKeeper_Gateway_Addon();
