<?php
class ControllerExtensionPaymentPaykeepersbp extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/payment/paykeepersbp');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('payment_paykeepersbp', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			//$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', 'SSL'));
			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_pay'] = $this->language->get('text_pay');
		$data['text_card'] = $this->language->get('text_card');

		$data['entry_paykeepersbpserver'] = $this->language->get('entry_paykeepersbpserver');
		$data['entry_paykeepersbpsecret'] = $this->language->get('entry_paykeepersbpsecret');
		$data['entry_order_status'] = $this->language->get('entry_order_status');
		$data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
        $data['entry_paykeepersbp_tru_code'] = $this->language->get('entry_paykeepersbp_tru_code');
        $data['entry_paykeepersbp_pstype'] = $this->language->get('entry_paykeepersbp_pstype');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$data['entry_callback'] = $this->language->get('entry_callback');
		$data['entry_success_link'] = $this->language->get('entry_success_link');
		$data['entry_failed_link'] = $this->language->get('entry_failed_link');

		$data['help_total'] = $this->language->get('help_total');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

        // ********************** Принудительный учет скидок ***************************************************************//
		if (isset($this->request->post['payment_paykeepersbp_force_discounts_check'])) {
			$data['payment_paykeepersbp_force_discounts_check'] = $this->request->post['payment_paykeepersbp_force_discounts_check'];
		} else {
			$data['payment_paykeepersbp_force_discounts_check'] = $this->config->get('payment_paykeepersbp_force_discounts_check');
		}
		//*******************************************************************************************************************//

        if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['paykeepersbpserver'])) {
			$data['error_paykeepersbpserver'] = $this->error['paykeepersbpserver'];
		} else {
			$data['error_paykeepersbpserver'] = '';
		}

		if (isset($this->error['paykeepersbpsecret'])) {
			$data['error_paykeepersbpsecret'] = $this->error['paykeepersbpsecret'];
		} else {
			$data['error_paykeepersbpsecret'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_payment'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], 'type=payment', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/payment/paykeepersbp', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/payment/paykeepersbp', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

		if (isset($this->request->post['payment_paykeepersbpserver'])) {
			$data['payment_paykeepersbpserver'] = $this->request->post['payment_paykeepersbpserver'];
		} else {
			$data['payment_paykeepersbpserver'] = $this->config->get('payment_paykeepersbpserver');
		}

		if (isset($this->request->post['payment_paykeepersbpsecret'])) {
			$data['payment_paykeepersbpsecret'] = $this->request->post['payment_paykeepersbpsecret'];
		} else {
			$data['payment_paykeepersbpsecret'] = $this->config->get('payment_paykeepersbpsecret');
		}

		if (isset($this->request->post['payment_paykeepersbp_order_status_id'])) {
			$data['payment_paykeepersbp_order_status_id'] = $this->request->post['payment_paykeepersbp_order_status_id'];
		} else {
			$data['payment_paykeepersbp_order_status_id'] = $this->config->get('payment_paykeepersbp_order_status_id');
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['payment_paykeepersbp_geo_zone_id'])) {
			$data['payment_paykeepersbp_geo_zone_id'] = $this->request->post['payment_paykeepersbp_geo_zone_id'];
		} else {
			$data['payment_paykeepersbp_geo_zone_id'] = $this->config->get('payment_paykeepersbp_geo_zone_id');
		}

		//$this->load->model('localisation/geo_zone');

		//$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        if (isset($this->request->post['payment_paykeepersbp_tru_code'])) {
            $data['payment_paykeepersbp_tru_code'] = $this->request->post['payment_paykeepersbp_tru_code'];
        } else {
            $data['payment_paykeepersbp_tru_code'] = $this->config->get('payment_paykeepersbp_tru_code');
        }

        if (isset($this->request->post['payment_paykeepersbp_pstype'])) {
            $data['payment_paykeepersbp_pstype'] = $this->request->post['payment_paykeepersbp_pstype'];
        } else {
            $data['payment_paykeepersbp_pstype'] = $this->config->get('payment_paykeepersbp_pstype');
        }

		if (isset($this->request->post['payment_paykeepersbp_status'])) {
			$data['payment_paykeepersbp_status'] = $this->request->post['payment_paykeepersbp_status'];
		} else {
			$data['payment_paykeepersbp_status'] = $this->config->get('payment_paykeepersbp_status');
		}

		if (isset($this->request->post['payment_paykeepersbp_sort_order'])) {
			$data['payment_paykeepersbp_sort_order'] = $this->request->post['payment_paykeepersbp_sort_order'];
		} else {
			$data['payment_paykeepersbp_sort_order'] = $this->config->get('payment_paykeepersbp_sort_order');
		}

		if (isset($this->request->post['payment_paykeepersbp_status'])) {
			$data['payment_paykeepersbp_partial_payment_status'] = $this->request->post['payment_paykeepersbp_partial_payment_status'];
		} else {
			$data['payment_paykeepersbp_partial_payment_status'] = $this->config->get('payment_paykeepersbp_partial_payment_status');
		}

		if (isset($this->request->post['payment_paykeepersbp_partial_payment_name}'])) {
			$data['payment_paykeepersbp_partial_payment_name'] = $this->request->post['payment_paykeepersbp_partial_payment_name'];
		} else {
			$data['payment_paykeepersbp_partial_payment_name'] = $this->config->get('payment_paykeepersbp_partial_payment_name');
		}

		if (isset($this->request->post['payment_paykeepersbp_partial_payment_percent}'])) {
			$data['payment_paykeepersbp_partial_payment_percent'] = $this->request->post['payment_paykeepersbp_partial_payment_percent'];
		} else {
			$data['payment_paykeepersbp_partial_payment_percent'] = $this->config->get('payment_paykeepersbp_partial_payment_percent');
		}

        $data['url_link_callback'] = $this->url->link('extension/payment/paykeepersbp/callback', '', true);
        $data['url_link_callback'] = preg_replace('#/[^/]+/index\.php#', '/index.php', $data['url_link_callback']);
        $data['url_link_success'] = $this->url->link('extension/payment/paykeepersbp/success', '', true);
        $data['url_link_success'] = preg_replace('#/[^/]+/index\.php#', '/index.php', $data['url_link_success']);
        $data['url_link_failed'] = $this->url->link('extension/payment/paykeepersbp/failed', '', true);
        $data['url_link_failed'] = preg_replace('#/[^/]+/index\.php#', '/index.php', $data['url_link_failed']);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/payment/paykeepersbp', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/payment/paykeepersbp')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['payment_paykeepersbpserver']) {
			$this->error['paykeepersbpserver'] = $this->language->get('error_paykeepersbpserver');
		}

		if (!$this->request->post['payment_paykeepersbpsecret']) {
			$this->error['paykeepersbpsecret'] = $this->language->get('error_paykeepersbpsecret');
		}

		return !$this->error;
	}
}