<?php
/**
  *	@author Paykeeper;
  * @version v 2.2  ;
  * @copyright ООО "Пейкипер процессинг";
  */

// Including the PayKeeper class for payment processing
require_once('paykeeper.class.php');

class ControllerExtensionPaymentPaykeeper extends Controller
{
	public function index()
    {
		$data['button_confirm'] = $this->language->get('button_confirm');

        if (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1)
            || isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https'
            || $this->config->get('config_ssl'))
        {
            $ssl_use = true;
        } else {
            $ssl_use = false;
        }

        $data['url_confirm'] = $this->url->link('extension/payment/paykeeper/gopay', '', $ssl_use);

        return $this->load->view('/extension/payment/paykeeper', $data);
	}

    /**
     * Callback method for handling PayKeeper payment confirmation.
     *
     * This method verifies the integrity of the payment notification data
     * received from PayKeeper. It checks for the correct hash, validates
     * the order existence, and ensures the payment amount matches the order total.
     * Upon successful validation, it updates the order status.
     *
     * @return void Outputs success message or error message based on validation checks.
     */
	public function callback()
    {
        // Exit if no POST data is received
        if (!isset($this->request->post)) {
            exit;
        }

        // Check if required POST parameters are present
        if (!isset($this->request->post['id']) || empty($this->request->post['orderid'])) {
            echo 'Error! Invalid request!';
            exit;
        }

        $this->load->model('checkout/order');

        // Extract and validate key parameters from POST data
        $secret_seed = $this->config->get('payment_paykeepersecret');
        $id = $this->request->post['id'];
        $sum = $this->request->post['sum'];
        $clientid = $this->request->post['clientid'];
        $orderid = $this->request->post['orderid'];
        $key = $this->request->post['key'];

        // Validate hash to ensure data integrity
        $pk_key = md5($id . sprintf("%.2lf", $sum) . $clientid . $orderid . $secret_seed);
        if (!hash_equals($pk_key, $key)) {
            echo 'Error! Hash mismatch';
            exit;
        }

        // Retrieve order details and validate the order ID
        $order_info = $this->model_checkout_order->getOrder($orderid);
        if (!isset($order_info['order_id'])) {
            echo 'Error! Order was not found';
            exit;
        }

        // Verify that the order total matches the payment amount
        $order_total = $this->_formatPrice($order_info['total'], $order_info);
        $sum_format = number_format($sum, 2, '.', '');
        if ($order_total !== $sum_format) {
            echo 'Error! Incorrect order sum!';
            exit;
        }

        // Update order status to reflect successful payment
        $this->model_checkout_order->addOrderHistory($orderid, $this->config->get('payment_paykeeper_order_status_id'));

        // Output success message with confirmation hash
        echo 'OK ' . md5($id . $secret_seed);
        exit;
	}
	
	public function gopay() {

		$this->load->language('checkout/checkout');
		$this->load->language('extension/payment/paykeeper');
		
		$data['breadcrumbs'] = array();
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_cart'),
			'href' => $this->url->link('checkout/cart')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('checkout/checkout', '', 'SSL')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('paykeeper_title'),
			'href' => $this->url->link('extension/payment/paykeeper/gopay', '', 'SSL')
		);

        $data['heading_title'] = $this->language->get('paykeeper_title');
		$this->document->setTitle($data['heading_title']);
		
		$this->load->model('checkout/order');

		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

        // Redirect to cart if no products are in the cart
        if (!$this->cart->hasProducts()) {
            $this->response->redirect($this->url->link('checkout/cart', '', true));
        }

        //generate payment form
        $data["form"] = $this->generatePaymentForm($this->session->data['order_id']);

        $this->response->setOutput($this->load->view('extension/payment/paykeeper_iframe', $data));
	}

	public function success() {
		$this->load->language('checkout/checkout');
		$this->load->language('extension/payment/paykeeper');

        //clear cart
        $this->cart->clear();
		
		$data['heading_title'] = $this->language->get('paykeeper_title');
		$data['breadcrumbs'] = array();
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_cart'),
			'href' => $this->url->link('checkout/cart')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('checkout/checkout', '', 'SSL')
		);
		$data['message'] = $this->language->get('paykeeper_success');

		$this->document->setTitle($data['message']);
		
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');
		
        $this->response->setOutput($this->load->view('extension/payment/paykeeper_feedback', $data));
	}

	public function failed() {
		$this->load->language('checkout/checkout');
		$this->load->language('extension/payment/paykeeper');
		
		$data['heading_title'] = $this->language->get('paykeeper_title');
		$data['breadcrumbs'] = array();
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_cart'),
			'href' => $this->url->link('checkout/cart')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('checkout/checkout', '', 'SSL')
		);
		
		$data['message'] = $this->language->get('paykeeper_failed');
		$this->document->setTitle($data['message']);
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');
        $this->response->setOutput($this->load->view('extension/payment/paykeeper_feedback', $data));
	}

    /**
     * Confirms the order by updating its status.
     *
     * This method sets the initial status of the order to "Pending" (status ID 1).
     * It is typically called when a payment has been initiated but not yet completed.
     *
     * @return void Updates the order history with the pending status.
     */
    public function confirm()
    {
        if ($this->config->get('payment_paykeeper_create_order') == 1) {
            // Load the order model
            $this->load->model('checkout/order');

            // Load the settings model
            $this->load->model('setting/setting');

            // Get the default order status ID from the settings
            $default_order_status_id = $this->config->get('config_order_status_id');

            // Add an order history entry with the default status for the newly created order
            $this->model_checkout_order->addOrderHistory($this->session->data['order_id'], $default_order_status_id);
        }
    }

    /**
     * Generates a payment form for PayKeeper payment gateway.
     * This function creates the HTML form for submitting payment details to PayKeeper's payment server
     * and processes additional information such as shipping, low order fees, and cart items.
     *
     * @param int $order_id The unique identifier for the order.
     *
     * @return string HTML content for the payment form or an error message if form generation fails.
     */
    public function generatePaymentForm($order_id)
    {
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($order_id);

        //GENERATING PAYKEEPER PAYMENT FORM
        $pk_obj = new PaykeeperPayment();

        //set order params
        $pk_obj->setOrderParams(
            //sum
            $this->_formatPrice($order_info['total'], $order_info),
            //clientid
            trim($order_info['firstname'] . " " . $order_info['lastname']),
            //orderid
            $order_info['order_id'],
            //client_email
            $order_info['email'],
            //client_phone
            $order_info['telephone'],
            //service_name
            '',
            //payment form url
            $this->config->get('payment_paykeeperserver'),
            //secret key
            $this->config->get('payment_paykeepersecret')
        );

        //GENERATE FZ54 CART

        $order_products = $this->cart->getProducts();
        $last_index = 0;
        foreach ($order_products as $product) {
            $taxes = array("tax" => "none", "tax_sum" => 0);
            $name = strip_tags($product["name"]);
            //vat included in price
            $price = floatval($product['price']);
            $quantity = floatval($product['quantity']);

            // For the correctPrecision method
            if ($quantity == 1 && $pk_obj->single_item_index < 0) {
                $pk_obj->single_item_index = $last_index;
            }
            if ($quantity > 1 && $pk_obj->more_then_one_item_index < 0) {
                $pk_obj->more_then_one_item_index = $last_index;
            }

            if ($product["tax_class_id"]) {
                $tax_rate = $this->getRate($price, $product["tax_class_id"]);
                $taxes = $pk_obj->setTaxes($tax_rate, false);
                $price = $this->tax->calculate($price, $product['tax_class_id']);
            }
            $price = $this->_formatPrice($price, $order_info);

            $pk_obj->updateFiscalCart(
                $pk_obj->getPaymentFormType(),
                $name,
                $price,
                $quantity,
                0,
                $taxes["tax"]
            );

            // ТРУ код
            if (!empty($this->config->get('payment_paykeeper_tru_code'))) {
                $this->load->model('catalog/product');
                $tru_value = $this->config->get('payment_paykeeper_tru_code');
                $tru_code = '';

                // Получение кода ТРУ из данных товара
                $product_info = $this->model_catalog_product->getProduct($product['product_id']);
                if ($product_info) {
                    if (!empty($product_info[$tru_value])) {
                        $tru_code = $product_info[$tru_value];
                    }
                }

                // Получение кода ТРУ из корзины товара
                if (!empty($product[$tru_value])) {
                    $tru_code = $product[$tru_value];
                }

                // Получение кода ТРУ из атрибутов товара
                $product_attributes = $this->model_catalog_product->getProductAttributes($product['product_id']);
                foreach ($product_attributes as $attribute_group) {
                    foreach ($attribute_group['attribute'] as $attribute) {
                        if ($attribute['name'] == $tru_value) {
                            $tru_code = $attribute['text'];
                        }
                    }
                }

                // Получение кода ТРУ из опций товара
                $product_options = $this->model_catalog_product->getProductOptions($product['product_id']);
                foreach ($product_options as $option) {
                    foreach ($product['option'] as $cart_option) {
                        if ($cart_option['product_option_id'] == $option['product_option_id']) {
                            foreach ($option['product_option_value'] as $option_value) {
                                if ($option_value['product_option_value_id'] == $cart_option['product_option_value_id']) {
                                    // Здесь предполагается, что ТРУ код хранится в поле 'tru_code'
                                    if (!empty($option_value[$tru_value])) {
                                        $tru_code = $option_value[$tru_value];
                                    }
                                }
                            }
                        }
                    }
                }

                if ($tru_code) {
                    $pk_obj->fiscal_cart[$last_index]['tru_code'] = $tru_code;
                }
            }

            $last_index++;
        }

        //add shipping parameters to cart
        if (isset($this->session->data['shipping_method'])) {
            $shipping_method = $this->session->data['shipping_method'];
            $shipping_taxes = array("tax" => "none", "tax_sum" => 0);
            $shipping_name = strip_tags($shipping_method['title']);
            $shipping_price = floatval($shipping_method['cost']);
            if ($shipping_method["tax_class_id"]) {
                $shipping_tax_rate = $this->getRate($shipping_price, $shipping_method["tax_class_id"]);
                $shipping_taxes = $pk_obj->setTaxes($shipping_tax_rate, false);
                $shipping_price = $this->tax->calculate($shipping_price, $shipping_method['tax_class_id']);
            }
            $shipping_price = $this->_formatPrice($shipping_price, $order_info);
            $pk_obj->setShippingPrice($shipping_price);
            if (!$pk_obj->checkDeliveryIncluded($pk_obj->getShippingPrice(), $shipping_name)
                && $pk_obj->getShippingPrice() > 0)
            {
                $pk_obj->setUseDelivery(); //for precision correct check
                $pk_obj->updateFiscalCart(
                    $pk_obj->getPaymentFormType(),
                    $shipping_name,
                    $pk_obj->getShippingPrice(),
                    1,
                    0,
                    $shipping_taxes['tax']
                );
                $pk_obj->delivery_index = $last_index;
                $pk_obj->fiscal_cart[$last_index]['item_type'] = 'service';
            }
        }

        //set discounts
        $pk_obj->setDiscounts(isset($this->session->data['coupon'])
            || isset($this->session->data['voucher'])
            || $this->config->get("payment_paykeeper_force_discounts_check") == "1"
        );

        //handle possible precision problem
        $pk_obj->correctPrecision();

        $fiscal_cart_encoded = $pk_obj->getFiscalCartEncoded();

        //generate payment form
        $form = "";
        if ($pk_obj->getPaymentFormType() == "create") { //create form
            $sign = $this->getFormSign($pk_obj, $pk_obj->getOrderTotal());

            $pp_option_code = '';
            $pp_option_jcode = 'window.addEventListener("load", sendForm);'; // redirect
            if ($this->config->get('payment_paykeeper_partial_payment_status') == 1) {
                $pp_percent = floatval($this->config->get('payment_paykeeper_partial_payment_percent'));
                $pp_sum = $pk_obj->getOrderTotal()/100*$pp_percent;
                $pp_cart = array();
                $pp_cart[] = array(
                    "name" => $this->config->get('payment_paykeeper_partial_payment_name'),
                    "price" => $pp_sum,
                    "quantity" => 1,
                    "sum" => $pp_sum,
                    "tax" => "none"
                );
                $pp_cart_encoded = json_encode($pp_cart);
                $pp_sign = $this->getFormSign($pk_obj, $pp_sum);

                $pp_option_code = '
                    <div>
                    <select name="pp_option" id="pp_option">
                        <option value="'.htmlentities($fiscal_cart_encoded,ENT_QUOTES).'">Полная оплата</option>
                        <option value="'.htmlentities($pp_cart_encoded,ENT_QUOTES).'">Частичная оплата ('.$pp_percent.'% от суммы заказа)</</option>
                    </select>
                    </div><br>
                ';
                $pp_option_jcode = '
                $(document).ready(function(){
                    $("#pp_option").on("change", function(event) {
                        $("#paykeeper_cart").val(this.value);
                        $("#paykeeper_sum").val('.$pp_sum.');
                        $("#paykeeper_sign").val("'.$pp_sign.'");
                    });
                });
                ';
            }

            $form = '
                <h3>Нажмите на кнопку "Оплатить", чтобы Вы были перенаправлены на страницу банка.</h3> 
                <form name="pay_form" id="pay_form" action="'.$pk_obj->getOrderParams("form_url").'" accept-charset="utf-8" method="post">
                    '.$pp_option_code.'
                    <input type="hidden" id="paykeeper_sum" name="sum" value = "'.$pk_obj->getOrderTotal().'"/>
                    <input type="hidden" name="orderid" value = "'.$pk_obj->getOrderParams("orderid").'"/>
                    <input type="hidden" name="clientid" value = "'.$pk_obj->getOrderParams("clientid").'"/>
                    <input type="hidden" name="client_email" value = "'.$pk_obj->getOrderParams("client_email").'"/>
                    <input type="hidden" name="client_phone" value = "'.$pk_obj->getOrderParams("client_phone").'"/>
                    <input type="hidden" name="service_name" value = "'.$pk_obj->getOrderParams("service_name").'"/>
                    <input type="hidden" id="paykeeper_cart" name="cart" value = \''.htmlentities($fiscal_cart_encoded,ENT_QUOTES).'\' />
                    <input type="hidden" id="paykeeper_sign" name="sign" value = "'.$sign.'"/>
                    <input type="button" id="button-confirm" value="Оплатить"/>
                </form>
                <script>
                '.$pp_option_jcode.'
                function sendForm() {
                    $.ajax({ 
                        type: "get",
                        url: "index.php?route=extension/payment/paykeeper/confirm",
                        success: function() {
                            $("#pay_form").submit();
                        }       
                    });
                }
                $("#button-confirm").on("click", function() {
                    sendForm();
                });
                </script>';
        }
        else { //order form
            $payment_parameters = array(
                "clientid"=>$pk_obj->getOrderParams("clientid"), 
                "orderid"=>$pk_obj->getOrderParams('orderid'), 
                "sum"=>$pk_obj->getOrderTotal(), 
                "phone"=>$pk_obj->getOrderParams("phone"), 
                "client_email"=>$pk_obj->getOrderParams("client_email"), 
                "cart"=>$fiscal_cart_encoded);
            $query = http_build_query($payment_parameters);
            $query_options = array("http"=>array(
                "method"=>"POST",
                "header"=>"Content-type: application/x-www-form-urlencoded",
                "content"=>$query
                ));
            $context = stream_context_create($query_options);

            if( function_exists( "curl_init" )) { //using curl
                $CR = curl_init();
                curl_setopt($CR, CURLOPT_URL, $pk_obj->getOrderParams("form_url"));
                curl_setopt($CR, CURLOPT_POST, 1);
                curl_setopt($CR, CURLOPT_FAILONERROR, true); 
                curl_setopt($CR, CURLOPT_POSTFIELDS, $query);
                curl_setopt($CR, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($CR, CURLOPT_SSL_VERIFYPEER, 0);
                $result = curl_exec( $CR );
                $error = curl_error( $CR );
                if( !empty( $error )) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR:".$error."</span>";
                }
                else {
                    $form = $result;
                }
                curl_close($CR);
            }
            else { //using file_get_contents
                if (!ini_get('allow_url_fopen')) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR: Option allow_url_fopen is not set in php.ini"."</span>";
                }
                else {
                    $form = file_get_contents($pk_obj->getOrderParams("form_url"), false, $context);
                }
            }
        }
        if ($form == "") {
            $form = '<h3>Произошла ошибка при инциализации платежа</h3>';
        }

        return $form;
    }

    protected function getRate($sum, $tax_class_id)
    {   
        $tax_data = Null;
        foreach($this->tax->getRates($sum, $tax_class_id) as $td) {
            $tax_data = $td;
        }
        return ($tax_data) ? (int)$tax_data['rate'] : 0;

    }

    private function getFormSign($pk_obj, $order_sum)
    {
        $to_hash = number_format($order_sum, 2, ".", "") .
            $pk_obj->getOrderParams("clientid")     .
            $pk_obj->getOrderParams("orderid")      .
            $pk_obj->getOrderParams("service_name") .
            $pk_obj->getOrderParams("client_email") .
            $pk_obj->getOrderParams("client_phone") .
            $pk_obj->getOrderParams("secret_key");
        $sign = hash ('sha256' , $to_hash);
        return $sign;

    }

    /**
     * Formats the given price according to the order's currency settings.
     *
     * This function takes a price and the order information, formats the price based on
     * the currency code and value of the order, and returns the formatted price with
     * two decimal places.
     *
     * @param float $price The price to be formatted.
     * @param array $order_info An associative array containing order details, including:
     *     - 'currency_code' (string): The currency code (e.g., 'USD', 'EUR').
     *     - 'currency_value' (float): The value of the currency relative to the default currency (usually 1.0).
     *
     * @return string The formatted price with two decimal places.
     *
     * @example
     * $order_info = [
     *     'currency_code' => 'USD',
     *     'currency_value' => 1.0
     * ];
     * $formattedPrice = $this->_formatPrice(100.345, $order_info);
     * echo $formattedPrice; // Outputs: "100.35"
     */
    private function _formatPrice($price, $order_info) {
        $price = $this->currency->format(
            floatval($price),
            $order_info['currency_code'],
            $order_info['currency_value'],
            false
        );
        return number_format($price,2 ,'.', '');
    }
}
