<?php

include_once __DIR__ . \DIRECTORY_SEPARATOR . 'vendor/Paykeeper_methodHelper.class.php';

/*
 * Plugins "PayKeeper" for Shop-Script
 *
 * @author PayKeeper
 * @name PayKeeper
 * @description Плагин оплаты через PayKepeer.
 *
 * Поля, доступные в виде параметров настроек плагина, указаны в файле lib/config/settings.php.
 * @property-read string $pk_url_link
 * @property-read string $pk_secret_key
*/
class paykeeper_methodPayment extends waPayment implements waIPayment
{
    private $submit_button_class = "";
    protected $table = 'shop_order';

    /**
     * Currency (only RUB available)
     *
     * @return string
     */
    public function allowedCurrency()
    {
        return $currency = 'RUB';
    }


    /**
     * Redirect to payment form page
     *
     * @param $payment_form_data
     * @param $order_data
     * @param $form_html
     * @return mixed
     */
    public function payment($payment_form_data, $order_data, $form_html = true)
    {
        $pk_obj = new Paykeeper_methodHelper;

        // Required
        if (empty($order_data['description'])) {
            $order_data['description'] = 'Заказ '.$order_data['order_id'];
        }

        // Initialize order object
        $order = waOrder::factory($order_data);

        $customer = new waContact($order_data["contact_id"]);

        // Set order parameters
        $orderid = $order_data["id_str"] . "|" .
            $order_data["order_id"] . "|" .
            $this->app_id . "|" .
            $this->merchant_id;

        $email_data = $customer->get("email");
        $email = $email_data[0]["value"];
        $phone_data = $customer->get("phone");
        $phone = $phone_data[0]["value"];

        $pk_obj->setOrderParams(
            $order->total,            // sum
            $customer->get("name"),   // clientid
            $orderid,                 // orderid
            $email,                   // client_email
            $phone,                   // client_phone
            "",                       // service_name
            $this->pk_url_link,       // payment form url
            $this->pk_secret_key      // secret key
        );

        // GENERATE FZ54 CART
        $cart_data = $order_data["items"];
        $last_index = 0;

        foreach ($cart_data as $cart_item) {

            // Формируем данные для ТРУ кода
            $tru_code = '';
            if (class_exists('shopProduct') && !empty($this->pk_tru_code_field)) {
                $product = new shopProduct($cart_item['product_id']);
                if (method_exists($product, 'getSkuFeatures')) {
                    $featuresSkuProduct = $product->getSkuFeatures();
                    if (!empty($featuresSkuProduct[$this->pk_tru_code_field])) {
                        $tru_code = $featuresSkuProduct[$this->pk_tru_code_field];
                    }
                }
                if (!$tru_code && method_exists($product, 'getFeatures')) {
                    $featuresProduct = $product->getFeatures();
                    if (!empty($featuresProduct[$this->pk_tru_code_field])) {
                        $tru_code = $featuresProduct[$this->pk_tru_code_field];
                    }
                }

            }

            $name = $cart_item["name"];
            $quantity = $cart_item["quantity"];

            if (isset($cart_item["tax_rate"])) {
                $pk_obj->setUseTaxes();

                if ($cart_item["tax_included"] == 0) {
                    $price = $cart_item["price"] + $cart_item["price"]/100*$cart_item["tax_rate"];
                    $pk_obj->setOrderTotal($order->total+$order->tax);
                } else {
                    $price = $cart_item["price"];
                }
            } else {
                $price = $cart_item["price"];
            }

            if ($quantity == 1 && $pk_obj->single_item_index < 0) {
                $pk_obj->single_item_index = $last_index;
            }
            if ($quantity > 1 && $pk_obj->more_then_one_item_index < 0) {
                $pk_obj->more_then_one_item_index = $last_index;
            }

            $tax_rate = $cart_item["tax_rate"];
            $taxes = $pk_obj->setTaxes($tax_rate);

            $pk_obj->updateFiscalCart(
                $pk_obj->getPaymentFormType(),
                $name,
                $price,
                $quantity,
                0,
                $taxes["tax"]
            );

            if ($tru_code) {
                $pk_obj->fiscal_cart[$last_index]['tru_code'] = $tru_code;
            }

            $last_index++;
        }

        // Add shipping parameters to cart
        $shipping_tax_rate = 0;
        $shipping_taxes = array("tax" => "none", "tax_sum" => 0);
        $shipping_tax_rate = $order["shipping_tax_rate"];

        if ($order["shipping_tax_included"] == 0) {
            $shipping_tax_final = $order["shipping"] + ($shipping_tax_rate * $order["shipping"])/100;
        } else {
            $shipping_tax_final = $order["shipping"];
        }

        $pk_obj->setShippingPrice($shipping_tax_final);
        $shipping_name = $order["shipping_name"];
        $shipping_taxes = $pk_obj->setTaxes($shipping_tax_rate);

        if ($pk_obj->getShippingPrice() > 0) {
            $pk_obj->setUseDelivery(); // for precision correct check
            $pk_obj->updateFiscalCart(
                $pk_obj->getPaymentFormType(),
                $shipping_name,
                $pk_obj->getShippingPrice(),
                1,
                0,
                $shipping_taxes["tax"]
            );
            $pk_obj->delivery_index = $last_index;
            $pk_obj->fiscal_cart[$last_index]['item_type'] = 'service';
        }
        // Set discounts
        $pk_obj->setDiscounts(array_key_exists("coupon_discount", $order["params"]) || $this->pk_force_discounts_check ==1);

        // Handle possible precision problem
        $pk_obj->correctPrecision();

        // Generate payment form
        $form = "";

        if ($pk_obj->getPaymentFormType() == "create") { // Create form
            $to_hash = $this->getSumFormat($pk_obj->getOrderTotal()) .
                $pk_obj->getOrderParams("clientid")            .
                $pk_obj->getOrderParams("orderid")             .
                $pk_obj->getOrderParams("service_name")        .
                $pk_obj->getOrderParams("client_email")        .
                $pk_obj->getOrderParams("client_phone")        .
                $pk_obj->getOrderParams("secret_key");
            $sign = hash ('sha256' , $to_hash);

            $this->setSubmitButtonCSSClass("large bold");
            if ($this->pk_autoredirect) {
                $form .= '<h3>Сейчас Вы будете перенаправлены на страницу банка.</h3>';
            } else {
                $form .= '<h3>Нажмите кнопку Оплатить для перенаправления на страницу банка.</h3>';
            }
            $form .= '
                <form name="pk_payform" id="pk_payform" action="'.$pk_obj->getOrderParams("form_url").'" accept-charset="utf-8" method="post">
                    <input type="hidden" name="sum" value = "'.$pk_obj->getOrderTotal().'"/>
                    <input type="hidden" name="orderid" value = "'.$pk_obj->getOrderParams("orderid").'"/>
                    <input type="hidden" name="clientid" value = "'.$pk_obj->getOrderParams("clientid").'"/>
                    <input type="hidden" name="client_email" value = "'.$pk_obj->getOrderParams("client_email").'"/>
                    <input type="hidden" name="client_phone" value = "'.$pk_obj->getOrderParams("client_phone").'"/>
                    <input type="hidden" name="service_name" value = "'.$pk_obj->getOrderParams("service_name").'"/>
                    <input type="hidden" name="cart" value = \''.htmlentities($pk_obj->getFiscalCartEncoded(),ENT_QUOTES).'\' />
                    <input type="hidden" name="sign" value = "'.$sign.'"/>
                    <input type="submit" class="'.$this->getSubmitButtonCSSClass().'" value="Оплатить"/>
                </form>
                ';
            if ($this->pk_autoredirect) {
                $form .= '
                <script type="text/javascript">
                    document.forms["pk_payform"].submit();
                </script>';
            }

        }
        else { // Order form
            $payment_parameters = array(
                "clientid"=>$pk_obj->getOrderParams("clientid"),
                "orderid"=>$pk_obj->getOrderParams('orderid'),
                "sum"=>$pk_obj->getOrderTotal(),
                "phone"=>$pk_obj->getOrderParams("phone"),
                "client_email"=>$pk_obj->getOrderParams("client_email"),
                "cart"=>$pk_obj->getFiscalCartEncoded());
            $query = http_build_query($payment_parameters);
            if( function_exists( "curl_init" ))
            { // Using curl
                $CR = curl_init();
                curl_setopt($CR, CURLOPT_URL, $pk_obj->getOrderParams("form_url"));
                curl_setopt($CR, CURLOPT_POST, 1);
                curl_setopt($CR, CURLOPT_FAILONERROR, true);
                curl_setopt($CR, CURLOPT_POSTFIELDS, $query);
                curl_setopt($CR, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($CR, CURLOPT_SSL_VERIFYPEER, 0);
                $result = curl_exec( $CR );
                $error = curl_error( $CR );
                if (!empty($error)) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR:".$error."</span>";
                } else {
                    $form = $result;
                }
                curl_close($CR);
            }
            else { // Using file_get_contents
                if (!ini_get('allow_url_fopen')) {
                    $form = "<br/><span class=message>"."INTERNAL ERROR: Option allow_url_fopen is not set in php.ini"."</span>";
                } else {
                    $context_options = array (
                        'http' => array (
                            'method' => 'POST',
                            'header'=> "Content-type: application/x-www-form-urlencoded\r\n"
                                . "Content-Length: " . strlen($query) . "\r\n",
                            'content' => $query
                        )
                    );
                    $context = stream_context_create($context_options);
                    $form = file_get_contents($pk_obj->getOrderParams("form_url"), false, $context);
                }
            }
        }
        if ($form == "") {
            $form = '<h3>Произошла ошибка при инциализации платежа</h3>';
        }

        //render form
        $view = wa()->getView();
        $view->assign('form_html', $form);
        return $view->fetch($this->path.'/templates/payment.html');
    }

    /**
     * Инициируем callBack Функцию и подготавливаем переменные
     *
     * @param $request
     * @return mixed
     */
    protected function callbackInit($request)
    {
        waLog::dump($request);
        if (!empty($request['id']) && !empty($request['sum']) && !empty($request['clientid']) && !empty($request['orderid']) && !empty($request['key'])) {
            //parse orderid
            $orderid_data = $this->parseOrderId($request["orderid"]);
            $this->order_id = $orderid_data[1];
            $this->app_id = $orderid_data[2];
            $this->merchant_id = $orderid_data[3];
        } else {
            self::log($this->id, array('error' => 'empty required field(s)'));
            throw new waPaymentException('Empty required field(s)');
        }
        return parent::callbackInit($request);
    }

    /**
     * Выполняем проверку и выводим сообщения
     * Также пишем в лог или обновляем статус заказа в случае успеха
     *
     * @param $request
     * @return void
     */
    protected function callbackHandler($request)
    {
        // Приводим данные о транзакции к универсальному виду
        $transaction_data = $this->formalizeData($request);
        self::log("logs1", $transaction_data);
        $pk_create = md5($request['id'] . $this->getSumFormat($request['sum']) . $request['clientid'] .
            $request['orderid'] . $this->pk_secret_key);

        // Проверка хэша
        if (!hash_equals($pk_create, $request['key'])) {
            $message = 'Message digest incorrect';
            self::log($this->id, array('error' => $message));
            echo $message;
            exit();
        }

        // Если все хорошо выполняем и выводим ответ для ПС
        $callback_method = self::CALLBACK_PAYMENT;
        $transaction_data = $this->saveTransaction($transaction_data, $request);
        $result = $this->execAppCallback($callback_method,$transaction_data);
        waLog::dump($result);

        if (isset($result['error'])) {
            $message = !empty($result['error']) ? $result['error'] : 'wa transaction error';
            self::log($this->id, array('error' => $message));
            echo $message;
            exit();
        }

        // Принудительная смена статуса заказа
        if ($this->pk_force_change_status && empty($result['result'])) {
            $fields = array(
                'id' => $transaction_data['id'],
                'order_id' => $transaction_data['order_id'],
                'plugin' => $this->id,
                'app_id' => $this->app_id,
                'merchant_id' => $this->merchant_id,
                'error' => null,
            );
            $transaction_model = new waTransactionModel();
            $transaction = $transaction_model->getByFields($fields);

            // Если транзакция помечена как 'is_repeated', то принудительно меняем статус
            if (is_array($transaction) &&
                !empty(end($transaction)['result']) &&
                end($transaction)['result'] == 'is_repeated')
            {
                $params = $transaction_data;
                $params['payment_plugin_instance'] = &$this;
                $result_repeat = $this->getAdapter()->execCallbackHandler($callback_method, $params);
                waLog::dump($result_repeat);
                $transaction_model->updateById($transaction_data['id'], $transaction_data);
            }
        }

        self::log($this->id, array('result' => 'success'));
        echo 'OK ' . md5($request['id'].$this->pk_secret_key);
        exit();
    }

    /**
     * Подготавливаем массив для вставки в БД и определяем
     *
     * @param $request
     * @return mixed
     */
    protected function formalizeData($request)
    {
        // формируем полный список полей, относящихся к транзакциям, которые обрабатываются платежной системой payKeeper
        $fields = array(
            'id',
            'sum',
            'orderid',
            'clientid',
            'key'
        );
        foreach ($fields as $f) {
            if (!isset($request[$f])) {
                $request[$f] = null;
            }
        }
        $orderid_data = $this->parseOrderId($request["orderid"]);

        // выполняем базовую обработку данных
        $transaction_data = parent::formalizeData($request);
        // тип транзацкии
        $transaction_data['type'] = self::OPERATION_AUTH_CAPTURE;
        // идентификатор транзакции, присвоенный платежной системой
        $transaction_data['native_id'] = $request['id'];
        // Номер заказа
        $transaction_data['order_id'] = $orderid_data[1];
        // сумма заказа
        $transaction_data['amount'] = $this->getSumFormat($request['sum']);
        // идентификатор валюты заказа
        $transaction_data['currency_id'] = $this->allowedCurrency();
        $transaction_data['result'] = 1;
        $transaction_data['view_data'] = 'Оплачено через PayKeeper - статус ответа: success';
        // состояние транзакции
        $transaction_data['state'] = self::STATE_CAPTURED;

        return $transaction_data;
    }

    protected function setSubmitButtonCSSClass($class_string)
    {
        $this->submit_button_class = $class_string;
    }

    protected function getSubmitButtonCSSClass()
    {
        return $this->submit_button_class;
    }

    protected function parseOrderId($orderid)
    {
        return explode("|", $orderid);
    }

    /**
     * Converting the amount to the format
     * @param $sum
     * @return string
     */
    protected function getSumFormat($sum)
    {
        return number_format($sum, 2, '.', '');
    }
}